/*
 * Decompiled with CFR 0.152.
 */
package phex.download.swarming;

import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Iterator;
import java.util.List;
import phex.common.ServiceManager;
import phex.common.ThreadPool;
import phex.common.address.IpAddress;
import phex.connection.ConnectionFailedException;
import phex.connection.NetworkManager;
import phex.download.DownloadEngine;
import phex.download.DownloadStoppedException;
import phex.download.FileNotAvailableException;
import phex.download.HostBusyException;
import phex.download.PushHandler;
import phex.download.RangeUnavailableException;
import phex.download.ReconnectException;
import phex.download.RemotelyQueuedException;
import phex.download.swarming.SWDownloadCandidate;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SWDownloadSegment;
import phex.download.swarming.SWDownloadSet;
import phex.download.swarming.SwarmingManager;
import phex.host.UnusableHostException;
import phex.http.HTTPMessageException;
import phex.net.presentation.SocketFacade;
import phex.utils.NLogger;

public class SWDownloadWorker
implements Runnable {
    private boolean isTemporaryWorker;
    private boolean isRunning;
    private ThreadPool.Job threadJob;
    private DownloadEngine downloadEngine;
    private boolean insideCriticalSection;
    private boolean isDownloadStopped;

    public void setTemporaryWorker(boolean bl) {
        this.isTemporaryWorker = bl;
    }

    public boolean isTemporaryWorker() {
        return this.isTemporaryWorker;
    }

    public boolean isInsideCriticalSection() {
        return this.insideCriticalSection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        SwarmingManager swarmingManager = SwarmingManager.getInstance();
        try {
            boolean bl;
            while (this.isRunning && !(bl = swarmingManager.checkToStopWorker(this))) {
                Object var7_5;
                List list = swarmingManager.getCompletedDownloadFiles();
                this.moveDownloadFilesToDestination(list);
                this.isDownloadStopped = false;
                NLogger.debug("Download.Worker", (Object)(" - Allocating DownloadSet - " + this));
                SWDownloadSet sWDownloadSet = swarmingManager.allocateDownloadSet(this);
                if (sWDownloadSet == null) {
                    if (!this.isTemporaryWorker) break;
                    try {
                        swarmingManager.waitForNotify();
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
                NLogger.debug("Download.Worker", (Object)("Allocated DownloadSet: " + sWDownloadSet.toString() + " - " + this));
                try {
                    this.handleDownload(sWDownloadSet);
                    var7_5 = null;
                    if (sWDownloadSet == null) continue;
                }
                catch (Throwable throwable) {
                    var7_5 = null;
                    if (sWDownloadSet != null) {
                        NLogger.debug("Download.Worker", (Object)("Releasing DownloadSet: " + sWDownloadSet.toString() + " - " + this));
                        sWDownloadSet.releaseDownloadSet();
                    }
                    throw throwable;
                }
                NLogger.debug("Download.Worker", (Object)("Releasing DownloadSet: " + sWDownloadSet.toString() + " - " + this));
                sWDownloadSet.releaseDownloadSet();
                {
                }
            }
            Object var9_8 = null;
            swarmingManager.notifyWorkerShoutdown(this, !this.isRunning);
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            swarmingManager.notifyWorkerShoutdown(this, !this.isRunning);
            NLogger.debug("Download.Worker", (Object)("Download worker finished: " + this));
            throw throwable;
        }
        NLogger.debug("Download.Worker", (Object)("Download worker finished: " + this));
    }

    public void startWorker() {
        this.isRunning = true;
        this.threadJob = ThreadPool.getInstance().addJob(this, "SWDownloadWorker-" + Integer.toHexString(this.hashCode()));
        NLogger.debug("Download.Worker", (Object)("Started SWDownloadWorker " + this));
    }

    public void stopWorker() {
        NLogger.debug("Download.Worker", (Object)("Download worker has been instructed to stop running: " + this));
        this.isRunning = false;
        this.isDownloadStopped = true;
        this.stopDownloadInternal();
        Thread thread = this.threadJob.getAssociatedThread();
        if (thread != null) {
            thread.interrupt();
        }
    }

    public void waitTillFinished() {
        while (this.threadJob.getAssociatedThread() != null) {
            this.threadJob.waitForAssociatedThreadRelease();
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    private void stopDownloadInternal() {
        if (this.downloadEngine != null) {
            NLogger.debug("Download.Worker", (Object)("Download worker has been instructed to stop downloading: " + this));
            this.downloadEngine.stopDownload();
            this.downloadEngine = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleDownload(SWDownloadSet sWDownloadSet) {
        NLogger.debug("Download.Worker", (Object)("handleDownload() with: " + sWDownloadSet + " - " + this));
        SWDownloadFile sWDownloadFile = sWDownloadSet.getDownloadFile();
        SWDownloadCandidate sWDownloadCandidate = sWDownloadSet.getDownloadCandidate();
        if (sWDownloadCandidate.getResourceURN() == null && sWDownloadCandidate.getFileIndex() < 0L) {
            NLogger.warn("Download.Worker", (Object)("Download candidate has no associated file and URN is null:" + sWDownloadCandidate));
            sWDownloadCandidate.addToCandidateLog("Download candidate has no associated file and URN is null.");
            return;
        }
        if (!this.isRunning) return;
        if (this.isDownloadStopped) {
            return;
        }
        if (sWDownloadCandidate.isPushNeeded()) {
            this.connectDownloadEngineViaPush(sWDownloadSet, false);
        } else {
            this.connectDownloadEngine(sWDownloadSet);
        }
        if (this.downloadEngine == null) {
            return;
        }
        if (!this.isRunning) return;
        if (this.isDownloadStopped) {
            return;
        }
        try {
            try {
                this.insideCriticalSection = true;
                this.startDownload(sWDownloadSet);
            }
            catch (IOException iOException) {
                sWDownloadCandidate.addToCandidateLog(iOException.toString());
                sWDownloadCandidate.setStatus((short)12);
                NLogger.debug("Download.Worker", (Object)sWDownloadCandidate);
                NLogger.debug("Download.Worker", (Object)iOException.toString(), (Throwable)iOException);
                Object var6_5 = null;
                sWDownloadFile.removeQueuedCandidate(sWDownloadCandidate);
                this.stopDownloadInternal();
                NLogger.debug("Download.Worker", (Object)("Releasing DownloadSegment: " + sWDownloadSet.toString() + " - " + this));
                sWDownloadSet.releaseDownloadSegment();
                sWDownloadFile.verifyStatus();
                if (sWDownloadFile.isFileCompleted()) {
                    sWDownloadFile.moveToDestinationFile();
                }
                this.insideCriticalSection = false;
                return;
            }
            Object var6_4 = null;
            sWDownloadFile.removeQueuedCandidate(sWDownloadCandidate);
            this.stopDownloadInternal();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            sWDownloadFile.removeQueuedCandidate(sWDownloadCandidate);
            this.stopDownloadInternal();
            NLogger.debug("Download.Worker", (Object)("Releasing DownloadSegment: " + sWDownloadSet.toString() + " - " + this));
            sWDownloadSet.releaseDownloadSegment();
            sWDownloadFile.verifyStatus();
            if (sWDownloadFile.isFileCompleted()) {
                sWDownloadFile.moveToDestinationFile();
            }
            this.insideCriticalSection = false;
            throw throwable;
        }
        NLogger.debug("Download.Worker", (Object)("Releasing DownloadSegment: " + sWDownloadSet.toString() + " - " + this));
        sWDownloadSet.releaseDownloadSegment();
        sWDownloadFile.verifyStatus();
        if (sWDownloadFile.isFileCompleted()) {
            sWDownloadFile.moveToDestinationFile();
        }
        this.insideCriticalSection = false;
    }

    private void connectDownloadEngine(SWDownloadSet sWDownloadSet) {
        if (!this.isRunning || this.isDownloadStopped) {
            return;
        }
        NLogger.debug("Download.Worker", (Object)("connectDownloadEngine with: " + sWDownloadSet + " - " + this));
        SWDownloadCandidate sWDownloadCandidate = sWDownloadSet.getDownloadCandidate();
        SWDownloadFile sWDownloadFile = sWDownloadSet.getDownloadFile();
        this.downloadEngine = null;
        this.downloadEngine = new DownloadEngine(sWDownloadFile, sWDownloadCandidate);
        if (!this.isRunning || this.isDownloadStopped) {
            return;
        }
        try {
            this.downloadEngine.connect(ServiceManager.sCfg.socketConnectTimeout);
        }
        catch (ConnectionFailedException connectionFailedException) {
            sWDownloadCandidate.addToCandidateLog(connectionFailedException.toString());
            NLogger.debug("Download.Worker", (Object)connectionFailedException.toString());
            this.connectDownloadEngineViaPush(sWDownloadSet, true);
            return;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            sWDownloadCandidate.addToCandidateLog(socketTimeoutException.toString());
            NLogger.debug("Download.Worker", (Object)socketTimeoutException.toString());
            this.connectDownloadEngineViaPush(sWDownloadSet, true);
            return;
        }
        catch (DownloadStoppedException downloadStoppedException) {
            sWDownloadCandidate.addToCandidateLog(downloadStoppedException.toString());
            sWDownloadCandidate.setStatus((short)13);
            NLogger.debug("Download.Worker", (Object)downloadStoppedException.toString());
            this.stopDownloadInternal();
            return;
        }
        catch (IOException iOException) {
            sWDownloadCandidate.addToCandidateLog(iOException.toString());
            NLogger.error("Download.Worker", (Object)("HardError at Host: " + sWDownloadCandidate.getHostAddress() + " Vendor: " + sWDownloadCandidate.getVendor()), (Throwable)iOException);
            this.stopDownloadInternal();
            this.connectDownloadEngineViaPush(sWDownloadSet, true);
            return;
        }
    }

    private void connectDownloadEngineViaPush(SWDownloadSet sWDownloadSet, boolean bl) {
        boolean bl2;
        if (!this.isRunning || this.isDownloadStopped) {
            return;
        }
        NLogger.debug("Download.Worker", (Object)("connectDownloadEngineViaPush with: " + sWDownloadSet + " - " + this));
        SWDownloadCandidate sWDownloadCandidate = sWDownloadSet.getDownloadCandidate();
        SWDownloadFile sWDownloadFile = sWDownloadSet.getDownloadFile();
        this.downloadEngine = null;
        IpAddress ipAddress = sWDownloadCandidate.getHostAddress().getIpAddress();
        boolean bl3 = bl2 = ServiceManager.sCfg.connectedToLAN && ipAddress != null && ipAddress.isSiteLocalIP();
        if (!NetworkManager.getInstance().hasConnectedIncoming() && !bl2) {
            NLogger.debug("Download.Worker", (Object)(this.toString() + sWDownloadCandidate.toString() + " Cant PUSH -> I'm firewalled and candidate not reachable by LAN"));
            sWDownloadCandidate.addToCandidateLog("Cant PUSH -> I'm firewalled and candidate not reachable by LAN");
            sWDownloadCandidate.setStatus((short)13);
            if (sWDownloadCandidate.isPushNeeded()) {
                sWDownloadFile.markCandidateBad(sWDownloadCandidate);
            }
            return;
        }
        if (sWDownloadCandidate.getGUID() == null) {
            NLogger.debug("Download.Worker", (Object)(this.toString() + sWDownloadCandidate.toString() + " Cant PUSH -> No candidate GUID."));
            sWDownloadCandidate.addToCandidateLog("Cant PUSH -> No candidate GUID.");
            sWDownloadCandidate.setStatus((short)13);
            return;
        }
        if (!this.isRunning || this.isDownloadStopped) {
            if (bl) {
                sWDownloadCandidate.setStatus((short)13);
            }
            return;
        }
        sWDownloadCandidate.setStatus((short)17);
        SocketFacade socketFacade = PushHandler.requestSocketViaPush(sWDownloadCandidate);
        if (socketFacade == null) {
            sWDownloadCandidate.setStatus((short)13);
            if (sWDownloadCandidate.isPushNeeded()) {
                sWDownloadFile.markCandidateIgnored(sWDownloadCandidate, "CandidateStatusReason_PushRouteFailed");
            }
            NLogger.debug("Download.Worker", (Object)("Push request fails for candidate: " + sWDownloadCandidate));
            sWDownloadCandidate.addToCandidateLog("Push request fails for candidate: " + sWDownloadCandidate);
            return;
        }
        this.downloadEngine = new DownloadEngine(sWDownloadFile, sWDownloadCandidate);
        if (!this.isRunning || this.isDownloadStopped) {
            return;
        }
        try {
            this.downloadEngine.setSocket(socketFacade);
        }
        catch (IOException iOException) {
            sWDownloadCandidate.addToCandidateLog(iOException.toString());
            sWDownloadCandidate.setStatus((short)13);
            NLogger.error("Download.Worker", (Object)("HardError at Host: " + sWDownloadCandidate.getHostAddress() + " Vendor: " + sWDownloadCandidate.getVendor()), (Throwable)iOException);
            this.stopDownloadInternal();
            return;
        }
    }

    private void exchangeHTTPHandshake(SWDownloadSet sWDownloadSet) {
        NLogger.debug("Download.Worker", (Object)("exchangeHTTPHandshake with: " + sWDownloadSet + " - " + this));
        SWDownloadCandidate sWDownloadCandidate = sWDownloadSet.getDownloadCandidate();
        SWDownloadFile sWDownloadFile = sWDownloadSet.getDownloadFile();
        try {
            sWDownloadCandidate.setStatus((short)19);
            SWDownloadSegment sWDownloadSegment = sWDownloadSet.allocateDownloadSegment(this);
            if (sWDownloadSegment == null) {
                NLogger.debug("Download.Worker", (Object)"No segment to allocate found");
                sWDownloadCandidate.addToCandidateLog("No segment to allocate found.");
                sWDownloadCandidate.setStatus((short)12);
                this.downloadEngine = null;
                return;
            }
            if (this.downloadEngine == null) {
                sWDownloadCandidate.addToCandidateLog("Connection interrupted.");
                sWDownloadCandidate.setStatus((short)12);
                return;
            }
            this.downloadEngine.exchangeHTTPHandshake(sWDownloadSegment);
        }
        catch (ReconnectException reconnectException) {
            sWDownloadCandidate.addToCandidateLog(reconnectException.toString());
            NLogger.debug("Download.Worker", (Object)(sWDownloadCandidate + " " + reconnectException.getMessage()));
            this.stopDownloadInternal();
            sWDownloadCandidate.setStatus((short)12);
        }
        catch (RemotelyQueuedException remotelyQueuedException) {
            sWDownloadCandidate.addToCandidateLog(remotelyQueuedException.toString());
            NLogger.debug("Download.Worker", (Object)("Releasing DownloadSegment (Queued): " + sWDownloadSet.toString() + " - " + this));
            sWDownloadSet.releaseDownloadSegment();
            sWDownloadCandidate.updateXQueueParameters(remotelyQueuedException.getXQueueParameters());
            sWDownloadCandidate.setStatus((short)18);
        }
        catch (RangeUnavailableException rangeUnavailableException) {
            boolean bl;
            sWDownloadCandidate.addToCandidateLog(rangeUnavailableException.toString());
            NLogger.debug("Download.Worker", (Object)(rangeUnavailableException.toString() + " :: " + sWDownloadCandidate));
            boolean bl2 = bl = sWDownloadCandidate.getAvailableScopeList() != null && sWDownloadCandidate.getAvailableScopeList().size() > 0;
            if (bl && sWDownloadFile.isScopeAllocateable(sWDownloadCandidate.getAvailableScopeList())) {
                NLogger.debug("Download.Worker", (Object)("Releasing DownloadSegment (Range): " + sWDownloadSet.toString() + " - " + this));
                sWDownloadSet.releaseDownloadSegment();
                sWDownloadCandidate.setStatus((short)15);
            } else {
                this.stopDownloadInternal();
                int n = rangeUnavailableException.getWaitTimeInSeconds() > 0 ? rangeUnavailableException.getWaitTimeInSeconds() : -1;
                sWDownloadCandidate.setStatus((short)15, n);
            }
        }
        catch (HostBusyException hostBusyException) {
            NLogger.debug("Download.Worker", (Object)(sWDownloadCandidate + " " + hostBusyException.getMessage()));
            this.stopDownloadInternal();
            sWDownloadCandidate.setStatus((short)14, hostBusyException.getWaitTimeInSeconds());
            return;
        }
        catch (UnusableHostException unusableHostException) {
            sWDownloadCandidate.addToCandidateLog(unusableHostException.toString());
            this.stopDownloadInternal();
            NLogger.debug("Download.Worker", (Object)unusableHostException, (Throwable)unusableHostException);
            NLogger.debug("Download.Worker", (Object)("Removing download candidate: " + sWDownloadCandidate));
            if (unusableHostException instanceof FileNotAvailableException) {
                sWDownloadFile.markCandidateIgnored(sWDownloadCandidate, "CandidateStatusReason_FileNotFound");
            } else {
                sWDownloadFile.markCandidateIgnored(sWDownloadCandidate, "CandidateStatusReason_Unusable");
            }
            sWDownloadFile.addBadAltLoc(sWDownloadCandidate);
            return;
        }
        catch (HTTPMessageException hTTPMessageException) {
            sWDownloadCandidate.addToCandidateLog(hTTPMessageException.toString());
            this.stopDownloadInternal();
            NLogger.warn("Download.Worker", (Object)hTTPMessageException, (Throwable)hTTPMessageException);
            sWDownloadFile.markCandidateIgnored(sWDownloadCandidate, "CandidateStatusReason_HTTPError");
            sWDownloadFile.addBadAltLoc(sWDownloadCandidate);
            return;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            sWDownloadCandidate.addToCandidateLog(socketTimeoutException.toString());
            NLogger.debug("Download.Worker", (Object)socketTimeoutException, (Throwable)socketTimeoutException);
            sWDownloadCandidate.setStatus((short)13);
            this.stopDownloadInternal();
            return;
        }
        catch (SocketException socketException) {
            sWDownloadCandidate.addToCandidateLog(socketException.toString());
            NLogger.debug("Download.Worker", (Object)socketException, (Throwable)socketException);
            sWDownloadCandidate.setStatus((short)13);
            this.stopDownloadInternal();
            return;
        }
        catch (IOException iOException) {
            sWDownloadCandidate.addToCandidateLog(iOException.toString());
            sWDownloadCandidate.setStatus((short)13);
            NLogger.warn("Download.Worker", (Object)("Error at Host: " + sWDownloadCandidate.getHostAddress() + " Vendor: " + sWDownloadCandidate.getVendor()), (Throwable)iOException);
            this.stopDownloadInternal();
            return;
        }
    }

    private void startDownload(SWDownloadSet sWDownloadSet) throws IOException {
        NLogger.debug("Download.Worker", (Object)("startDownload with: " + sWDownloadSet + " - " + this));
        SWDownloadFile sWDownloadFile = sWDownloadSet.getDownloadFile();
        SWDownloadCandidate sWDownloadCandidate = sWDownloadSet.getDownloadCandidate();
        sWDownloadCandidate.addToCandidateLog("Start download.");
        sWDownloadFile.addGoodAltLoc(sWDownloadCandidate);
        sWDownloadFile.markCandidateGood(sWDownloadCandidate);
        while (true) {
            this.exchangeHTTPHandshake(sWDownloadSet);
            if (this.downloadEngine == null) {
                return;
            }
            if (sWDownloadCandidate.isRemotlyQueued()) {
                boolean bl = sWDownloadFile.addAndValidateQueuedCandidate(sWDownloadCandidate);
                if (!bl) {
                    this.stopDownloadInternal();
                    return;
                }
                try {
                    Thread.sleep(sWDownloadCandidate.getXQueueParameters().getRequestSleepTime());
                    if (this.downloadEngine == null) {
                        NLogger.debug("Download.Worker", (Object)"Download stopped while waiting for queue.");
                        return;
                    }
                }
                catch (InterruptedException interruptedException) {
                    NLogger.debug("Download.Worker", (Object)"Interrupted Worker sleeping for queue.");
                    sWDownloadCandidate.setStatus((short)13);
                    this.stopDownloadInternal();
                    return;
                }
            }
            if (sWDownloadCandidate.isRemotlyQueued() || sWDownloadCandidate.isRangeUnavailable()) continue;
            sWDownloadFile.removeQueuedCandidate(sWDownloadCandidate);
            sWDownloadFile.setStatus((short)2);
            sWDownloadSet.getDownloadCandidate().setStatus((short)20);
            SWDownloadSegment sWDownloadSegment = sWDownloadSet.getDownloadSegment();
            this.downloadEngine.startDownload();
            sWDownloadCandidate.addToCandidateLog("Completed a segment which started at " + sWDownloadSegment.getStart() + " and was downloaded at a rate of " + sWDownloadSegment.getLongTermTransferRate());
            NLogger.debug("Download.Worker", (Object)("Completed a segment which started at " + sWDownloadSegment.getStart() + " and was downloaded at a rate of " + sWDownloadSegment.getLongTermTransferRate()));
            NLogger.debug("Download.Worker", (Object)("Releasing DownloadSegment (completed): " + sWDownloadSet.toString() + " - " + this));
            sWDownloadSet.releaseDownloadSegment();
            if (!this.isRunning || this.downloadEngine == null || !this.downloadEngine.isAcceptingNextSegment() || !sWDownloadFile.isScopeAllocateable(sWDownloadCandidate.getAvailableScopeList()) || this.isDownloadStopped) break;
        }
        sWDownloadCandidate.setStatus((short)12);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveDownloadFilesToDestination(List list) {
        this.insideCriticalSection = true;
        try {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                SWDownloadFile sWDownloadFile = (SWDownloadFile)iterator.next();
                if (!sWDownloadFile.isFileCompleted()) continue;
                if (sWDownloadFile.isDownloadFinished()) {
                    sWDownloadFile.moveToDestinationFile();
                    continue;
                }
                sWDownloadFile.stopDownload();
            }
        }
        finally {
            this.insideCriticalSection = false;
        }
    }

    public String toString() {
        return "[SWDownloadWorker@" + Integer.toHexString(this.hashCode()) + ":running:" + this.isRunning + ",tempWorker:" + this.isTemporaryWorker + ",engine:" + this.downloadEngine + "]";
    }
}

