/*
 * Decompiled with CFR 0.152.
 */
package phex.download;

import java.util.ArrayList;
import java.util.Iterator;
import phex.common.address.DestAddress;
import phex.download.PushRequestSleeper;
import phex.download.swarming.SWDownloadCandidate;
import phex.msg.GUID;
import phex.net.presentation.SocketFacade;
import phex.statistic.UploadDownloadCountStatistic;
import phex.utils.NLogger;

public class PushHandler {
    private static PushHandler singleton = new PushHandler();
    private ArrayList pushSleeperList = new ArrayList(5);

    private PushHandler() {
    }

    public static void handleIncommingGIV(SocketFacade socketFacade, GUID gUID, String string) {
        singleton.internalHandleIncommingGIV(socketFacade, gUID, string);
    }

    public static SocketFacade requestSocketViaPush(SWDownloadCandidate sWDownloadCandidate) {
        if (sWDownloadCandidate.getGUID() == null) {
            return null;
        }
        return singleton.internalRequestSocketViaPush(sWDownloadCandidate.getGUID(), sWDownloadCandidate.getFileIndex(), sWDownloadCandidate.getPushProxyAddresses());
    }

    public static SocketFacade requestSocketViaPush(GUID gUID, long l) {
        return singleton.internalRequestSocketViaPush(gUID, l, null);
    }

    public static void unregisterPushRequestSleeper(PushRequestSleeper pushRequestSleeper) {
        singleton.internalUnregisterPushRequestSleeper(pushRequestSleeper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalHandleIncommingGIV(SocketFacade socketFacade, GUID gUID, String string) {
        if (NLogger.isDebugEnabled("PUSH")) {
            NLogger.debug("PUSH", (Object)("Handle incomming GIV response:  - " + string));
        }
        ArrayList arrayList = this.pushSleeperList;
        synchronized (arrayList) {
            Iterator iterator = this.pushSleeperList.iterator();
            while (iterator.hasNext()) {
                boolean bl = ((PushRequestSleeper)iterator.next()).acceptGIVConnection(socketFacade, gUID);
                if (!bl) continue;
                if (NLogger.isDebugEnabled("PUSH")) {
                    NLogger.debug("PUSH", (Object)("Accepted GIV response:  - " + string));
                }
                return;
            }
        }
        if (NLogger.isDebugEnabled("PUSH")) {
            NLogger.debug("PUSH", (Object)("No Push request for GIV found: " + string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SocketFacade internalRequestSocketViaPush(GUID gUID, long l, DestAddress[] destAddressArray) {
        if (NLogger.isDebugEnabled("PUSH")) {
            NLogger.debug("PUSH", (Object)"Perform PUSH request...");
        }
        UploadDownloadCountStatistic.pushDownloadAttempts.increment(1);
        PushRequestSleeper pushRequestSleeper = new PushRequestSleeper(gUID, l, destAddressArray);
        Object object = this.pushSleeperList;
        synchronized (object) {
            this.pushSleeperList.add(pushRequestSleeper);
        }
        object = pushRequestSleeper.requestSocketViaPush();
        if (object == null) {
            if (NLogger.isDebugEnabled("PUSH")) {
                NLogger.debug("PUSH", (Object)"PUSH request failed.");
            }
            UploadDownloadCountStatistic.pushDownloadFailure.increment(1);
        } else {
            if (NLogger.isDebugEnabled("PUSH")) {
                NLogger.debug("PUSH", (Object)"PUSH request successful.");
            }
            UploadDownloadCountStatistic.pushDownloadSuccess.increment(1);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalUnregisterPushRequestSleeper(PushRequestSleeper pushRequestSleeper) {
        ArrayList arrayList = this.pushSleeperList;
        synchronized (arrayList) {
            this.pushSleeperList.remove(pushRequestSleeper);
        }
    }
}

