/*
 * Decompiled with CFR 0.152.
 */
package phex.download;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import phex.download.DownloadScope;

public class DownloadScopeList {
    private static DownloadScopeComparator DOWNLOAD_SCOPE_COMPARATOR;
    private int modificationCount = 0;
    private List scopeList = new ArrayList();
    private long aggregatedLengthCache = 0L;
    private int aggregatedLengthModCount = 0;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void addAll(DownloadScopeList downloadScopeList) {
        Iterator iterator = downloadScopeList.getScopeIterator();
        while (iterator.hasNext()) {
            DownloadScope downloadScope = (DownloadScope)iterator.next();
            this.add(downloadScope);
        }
    }

    public void add(DownloadScope downloadScope) {
        DownloadScope downloadScope2 = null;
        DownloadScope downloadScope3 = null;
        Iterator iterator = this.scopeList.iterator();
        while (iterator.hasNext()) {
            DownloadScope downloadScope4 = (DownloadScope)iterator.next();
            if (downloadScope.contains(downloadScope4)) {
                iterator.remove();
                continue;
            }
            if (downloadScope4.contains(downloadScope)) {
                return;
            }
            if (downloadScope.isNeighborBefore(downloadScope4)) {
                downloadScope2 = downloadScope4;
            }
            if (downloadScope.isNeighborAfter(downloadScope4)) {
                downloadScope3 = downloadScope4;
            }
            if (downloadScope3 == null && downloadScope4.getStart() <= downloadScope.getEnd()) continue;
        }
        if (downloadScope2 == null && downloadScope3 == null) {
            this.addInternal(downloadScope);
        } else if (downloadScope2 != null && downloadScope3 != null) {
            this.removeInternal(downloadScope2);
            this.removeInternal(downloadScope3);
            this.addInternal(new DownloadScope(downloadScope2.getStart(), downloadScope3.getEnd()));
        } else if (downloadScope3 != null) {
            this.removeInternal(downloadScope3);
            this.addInternal(new DownloadScope(downloadScope.getStart(), downloadScope3.getEnd()));
        } else if (downloadScope2 != null) {
            this.removeInternal(downloadScope2);
            this.addInternal(new DownloadScope(downloadScope2.getStart(), downloadScope.getEnd()));
        }
    }

    public void removeAll(DownloadScopeList downloadScopeList) {
        Iterator iterator = downloadScopeList.getScopeIterator();
        while (iterator.hasNext()) {
            DownloadScope downloadScope = (DownloadScope)iterator.next();
            this.remove(downloadScope);
        }
    }

    public void remove(DownloadScope downloadScope) {
        DownloadScope downloadScope2 = null;
        DownloadScope downloadScope3 = null;
        Iterator iterator = this.scopeList.iterator();
        while (iterator.hasNext()) {
            DownloadScope downloadScope4 = (DownloadScope)iterator.next();
            if (downloadScope4.isOverlapping(downloadScope)) {
                iterator.remove();
                if (downloadScope.getEnd() >= downloadScope4.getEnd()) {
                    if (downloadScope.getStart() <= downloadScope4.getStart()) continue;
                    downloadScope2 = new DownloadScope(downloadScope4.getStart(), downloadScope.getStart() - 1L);
                    continue;
                }
                if (downloadScope4.getStart() >= downloadScope.getStart()) {
                    downloadScope3 = new DownloadScope(downloadScope.getEnd() + 1L, downloadScope4.getEnd());
                    break;
                }
                downloadScope2 = new DownloadScope(downloadScope4.getStart(), downloadScope.getStart() - 1L);
                downloadScope3 = new DownloadScope(downloadScope.getEnd() + 1L, downloadScope4.getEnd());
                break;
            }
            if (downloadScope4.getStart() < downloadScope.getEnd()) continue;
        }
        if (downloadScope2 != null) {
            this.add(downloadScope2);
        }
        if (downloadScope3 != null) {
            this.add(downloadScope3);
        }
    }

    public void retainAll(DownloadScopeList downloadScopeList) {
        ListIterator<DownloadScope> listIterator = this.scopeList.listIterator();
        while (listIterator.hasNext()) {
            boolean bl = true;
            DownloadScope downloadScope = (DownloadScope)listIterator.next();
            Iterator iterator = downloadScopeList.getScopeIterator();
            while (iterator.hasNext()) {
                DownloadScope downloadScope2 = (DownloadScope)iterator.next();
                if (downloadScope.isOverlapping(downloadScope2)) {
                    listIterator.remove();
                    long l = Math.max(downloadScope2.getStart(), downloadScope.getStart());
                    long l2 = Math.min(downloadScope2.getEnd(), downloadScope.getEnd());
                    listIterator.add(new DownloadScope(l, l2));
                    bl = false;
                    break;
                }
                if (downloadScope2.getStart() < downloadScope.getEnd()) continue;
            }
            if (!bl) continue;
            listIterator.remove();
        }
    }

    public long getAggregatedLength() {
        if (this.modificationCount == this.aggregatedLengthModCount) {
            return this.aggregatedLengthCache;
        }
        long l = 0L;
        Iterator iterator = this.scopeList.iterator();
        while (iterator.hasNext()) {
            DownloadScope downloadScope = (DownloadScope)iterator.next();
            l += downloadScope.getLength();
        }
        this.aggregatedLengthCache = l;
        this.aggregatedLengthModCount = this.modificationCount;
        return l;
    }

    public Iterator getScopeIterator() {
        return this.scopeList.listIterator();
    }

    public int size() {
        return this.scopeList.size();
    }

    public DownloadScope getScopeAt(int n) {
        return (DownloadScope)this.scopeList.get(n);
    }

    public void clear() {
        this.scopeList.clear();
        this.aggregatedLengthCache = 0L;
        this.modificationCount = 0;
        this.aggregatedLengthModCount = 0;
    }

    public Object clone() {
        DownloadScopeList downloadScopeList = new DownloadScopeList();
        downloadScopeList.scopeList.addAll(this.scopeList);
        return downloadScopeList;
    }

    protected void addInternal(DownloadScope downloadScope) {
        int n = Collections.binarySearch(this.scopeList, downloadScope, DOWNLOAD_SCOPE_COMPARATOR);
        if (!$assertionsDisabled && n >= 0) {
            throw new AssertionError();
        }
        this.scopeList.add(-(n + 1), downloadScope);
        ++this.modificationCount;
    }

    protected void removeInternal(DownloadScope downloadScope) {
        int n = Collections.binarySearch(this.scopeList, downloadScope, DOWNLOAD_SCOPE_COMPARATOR);
        if (!$assertionsDisabled && n < 0) {
            throw new AssertionError();
        }
        this.scopeList.remove(n);
        ++this.modificationCount;
    }

    protected List getScopeListCopy() {
        return new ArrayList(this.scopeList);
    }

    static {
        $assertionsDisabled = !DownloadScopeList.class.desiredAssertionStatus();
        DOWNLOAD_SCOPE_COMPARATOR = new DownloadScopeComparator();
    }

    private static class DownloadScopeComparator
    implements Comparator {
        private DownloadScopeComparator() {
        }

        public int compare(Object object, Object object2) {
            DownloadScope downloadScope = (DownloadScope)object;
            DownloadScope downloadScope2 = (DownloadScope)object2;
            if (downloadScope == downloadScope2 || downloadScope.equals(downloadScope2)) {
                return 0;
            }
            if (downloadScope.getStart() > downloadScope2.getStart()) {
                return 1;
            }
            return -1;
        }
    }
}

