/*
 * Decompiled with CFR 0.152.
 */
package phex.download;

public class DownloadScope {
    private long start;
    private long end;

    public DownloadScope(long l, long l2) {
        if (l2 < l) {
            throw new IllegalArgumentException("endOffset < startOffset : " + l + " " + l2);
        }
        this.start = l;
        this.end = l2;
    }

    public long getEnd() {
        return this.end;
    }

    public long getStart() {
        return this.start;
    }

    public long getLength() {
        return this.end - this.start + 1L;
    }

    public boolean contains(DownloadScope downloadScope) {
        return this.start <= downloadScope.start && this.end >= downloadScope.end;
    }

    public boolean isNeighborBefore(DownloadScope downloadScope) {
        return this.start <= downloadScope.end + 1L && this.start > downloadScope.start;
    }

    public boolean isNeighborAfter(DownloadScope downloadScope) {
        return this.end >= downloadScope.start - 1L && this.end < downloadScope.end;
    }

    public boolean isOverlapping(DownloadScope downloadScope) {
        return this.end >= downloadScope.start && this.start <= downloadScope.end;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DownloadScope)) {
            return false;
        }
        DownloadScope downloadScope = (DownloadScope)object;
        return downloadScope.start == this.start && downloadScope.end == this.end;
    }

    public String toString() {
        return "[DownloadScope: start:" + this.start + ",end:" + this.end + "@" + Integer.toHexString(this.hashCode()) + "]";
    }
}

