/*
 * Decompiled with CFR 0.152.
 */
package phex.connection.handshake;

import java.io.IOException;
import phex.common.ServiceManager;
import phex.connection.ConnectionConstants;
import phex.connection.ConnectionRejectedException;
import phex.connection.ProtocolNotSupportedException;
import phex.http.HTTPHeaderGroup;
import phex.http.HTTPProcessor;
import phex.net.connection.Connection;
import phex.utils.NLogger;

public class HandshakeStatus
implements ConnectionConstants {
    private int statusCode;
    private String statusMessage;
    private HTTPHeaderGroup responseHeaders;

    public HandshakeStatus(int n, String string) {
        this(n, string, HTTPHeaderGroup.EMPTY_HEADERGROUP);
    }

    public HandshakeStatus(int n, String string, HTTPHeaderGroup hTTPHeaderGroup) {
        this.statusCode = n;
        this.statusMessage = string;
        this.responseHeaders = hTTPHeaderGroup;
    }

    public HandshakeStatus(HTTPHeaderGroup hTTPHeaderGroup) {
        this(200, "OK", hTTPHeaderGroup);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public HTTPHeaderGroup getResponseHeaders() {
        return this.responseHeaders;
    }

    public boolean isDeflateAccepted() {
        return ServiceManager.sCfg.isDeflateConnectionAccepted && this.responseHeaders.isHeaderValueContaining("Accept-Encoding", "deflate");
    }

    public static HandshakeStatus parseHandshakeResponse(Connection connection) throws ProtocolNotSupportedException, IOException {
        String string;
        int n;
        String string2 = connection.readLine();
        if (string2 == null) {
            throw new IOException("Disconnected from remote host during initial handshake");
        }
        if (!string2.startsWith("GNUTELLA/0.6")) {
            throw new ProtocolNotSupportedException("Bad protocol response: " + string2);
        }
        HTTPHeaderGroup hTTPHeaderGroup = HTTPProcessor.parseHTTPHeaders(connection);
        try {
            String string3 = string2.substring("GNUTELLA/0.6".length()).trim();
            int n2 = string3.indexOf(32);
            if (n2 == -1) {
                n2 = string3.length();
            }
            n = Integer.parseInt(string3.substring(0, n2));
            string = string3.substring(n2).trim();
        }
        catch (Exception exception) {
            NLogger.warn(HandshakeStatus.class, (Object)("Error parsing response: '" + string2 + "'."), (Throwable)exception);
            throw new ConnectionRejectedException("Error parsing response: '" + string2 + "'.");
        }
        return new HandshakeStatus(n, string, hTTPHeaderGroup);
    }
}

