/*
 * Decompiled with CFR 0.152.
 */
package phex.connection;

import java.io.IOException;
import java.util.EventListener;
import phex.common.AbstractManager;
import phex.common.GeneralGnutellaNetwork;
import phex.common.GnutellaNetwork;
import phex.common.NamedGnutellaNetwork;
import phex.common.ServiceManager;
import phex.common.address.AddressUtils;
import phex.common.address.DestAddress;
import phex.common.address.IpAddress;
import phex.event.AsynchronousDispatcher;
import phex.event.EventListenerList;
import phex.event.LoopbackListener;
import phex.event.NetworkListener;
import phex.gui.common.GUIRegistry;
import phex.gui.common.MainFrame;
import phex.gwebcache.GWebCacheManager;
import phex.host.HostManager;
import phex.net.OIOServer;
import phex.net.OnlineObserver;
import phex.net.Server;
import phex.net.presentation.PresentationManager;
import phex.query.QueryManager;
import phex.udp.hostcache.UdpHostCacheManager;
import phex.utils.NLogger;

public class NetworkManager
extends AbstractManager {
    private GnutellaNetwork gnutellaNetwork;
    private boolean isNetworkJoined;
    private boolean isConnected;
    private DestAddress forcedAddress;
    private DestAddress localAddress;
    private Server server;
    private OnlineObserver onlineObserver;
    private EventListenerList listenerList = new EventListenerList();

    private NetworkManager() {
        this.updateGnutellaNetwork();
        this.isNetworkJoined = ServiceManager.sCfg.mAutoJoin;
        this.isConnected = ServiceManager.sCfg.mAutoConnect;
    }

    public static NetworkManager getInstance() {
        return Holder.manager;
    }

    public boolean initialize() {
        this.onlineObserver = new OnlineObserver();
        return true;
    }

    public boolean onPostInitialization() {
        Object object;
        this.server = new OIOServer();
        try {
            this.server.startup();
        }
        catch (IOException iOException) {
            NLogger.error("STARTUP", (Object)iOException, (Throwable)iOException);
        }
        if (ServiceManager.sCfg.mMyIP.length() > 0) {
            object = new IpAddress(AddressUtils.parseIP(ServiceManager.sCfg.mMyIP));
            this.setForcedHostIP((IpAddress)object);
        }
        if (this.isNetworkJoined) {
            object = HostManager.getInstance();
            ((HostManager)object).getCaughtHostsContainer().initializeCaughtHostsContainer();
            ((HostManager)object).getFavoritesContainer().initializeFavorites();
            GWebCacheManager gWebCacheManager = GWebCacheManager.getInstance();
            gWebCacheManager.getGWebCacheContainer().initializeGWebCacheContainer();
            UdpHostCacheManager udpHostCacheManager = UdpHostCacheManager.getInstance();
            udpHostCacheManager.getUdpHostCacheContainer().initialize();
        }
        return true;
    }

    public void startupCompletedNotify() {
    }

    public void shutdown() {
        this.server.shutdown(false);
    }

    public void restartServer() throws IOException {
        this.server.restart();
    }

    public boolean hasConnectedIncoming() {
        return this.server.hasConnectedIncoming();
    }

    public synchronized void connectToNetwork() {
        if (this.isConnected) {
            return;
        }
        this.isConnected = true;
        this.onlineObserver.markSuccessfulConnection();
        if (!this.isNetworkJoined) {
            this.joinNetwork();
        }
        this.fireConnectedToNetwork();
    }

    public synchronized void disconnectNetwork() {
        this.isConnected = false;
        this.fireDisconnectedFromNetwork();
    }

    public synchronized void joinNetwork() {
        this.updateGnutellaNetwork();
        HostManager hostManager = HostManager.getInstance();
        hostManager.getCaughtHostsContainer().initializeCaughtHostsContainer();
        hostManager.getFavoritesContainer().initializeFavorites();
        GWebCacheManager gWebCacheManager = GWebCacheManager.getInstance();
        gWebCacheManager.getGWebCacheContainer().initializeGWebCacheContainer();
        this.isNetworkJoined = true;
        if (!this.isConnected && ServiceManager.sCfg.mAutoConnect) {
            this.connectToNetwork();
        }
        MainFrame mainFrame = GUIRegistry.getInstance().getMainFrame();
        mainFrame.setTitle();
    }

    public synchronized void leaveNetwork() {
        if (this.isNetworkJoined) {
            this.isNetworkJoined = false;
            this.disconnectNetwork();
            MainFrame mainFrame = GUIRegistry.getInstance().getMainFrame();
            mainFrame.setTitle();
            HostManager hostManager = HostManager.getInstance();
            hostManager.removeAllNetworkHosts();
            QueryManager.getInstance().getSearchContainer().stopAllSearches();
            hostManager.getCaughtHostsContainer().saveHostsContainer();
            hostManager.getFavoritesContainer().saveFavoriteHosts();
        }
    }

    public synchronized boolean isNetworkJoined() {
        return this.isNetworkJoined;
    }

    public synchronized boolean isConnected() {
        return this.isConnected;
    }

    public GnutellaNetwork getGnutellaNetwork() {
        return this.gnutellaNetwork;
    }

    private void updateGnutellaNetwork() {
        if (ServiceManager.sCfg.mCurrentNetwork.equals("<General Gnutella Network>")) {
            if (this.gnutellaNetwork == null || !(this.gnutellaNetwork instanceof GeneralGnutellaNetwork)) {
                this.gnutellaNetwork = new GeneralGnutellaNetwork();
            }
        } else if (this.gnutellaNetwork == null || !this.gnutellaNetwork.getName().equals(ServiceManager.sCfg.mCurrentNetwork)) {
            this.gnutellaNetwork = new NamedGnutellaNetwork(ServiceManager.sCfg.mCurrentNetwork);
        }
    }

    public OnlineObserver getOnlineObserver() {
        return this.onlineObserver;
    }

    public DestAddress getLocalAddress() {
        if (this.forcedAddress != null) {
            return this.forcedAddress;
        }
        return this.localAddress;
    }

    public void updateLocalAddress(DestAddress destAddress) {
        if (this.forcedAddress != null) {
            return;
        }
        if (this.localAddress == null || !this.localAddress.equals(destAddress)) {
            destAddress.setPort(this.server.getListeningLocalPort());
            this.localAddress = destAddress;
            this.server.resetFirewallCheck();
            this.fireNetworkIPChanged();
        }
    }

    public void setForcedHostIP(IpAddress ipAddress) {
        PresentationManager presentationManager = PresentationManager.getInstance();
        if (ipAddress == null) {
            this.forcedAddress = null;
            ServiceManager.sCfg.mMyIP = "";
            IpAddress ipAddress2 = this.server.resolveLocalHostIP();
            int n = this.server.getListeningLocalPort();
            DestAddress destAddress = presentationManager.createHostAddress(ipAddress2, n);
            this.updateLocalAddress(destAddress);
            return;
        }
        if (!ipAddress.isValidIP()) {
            throw new IllegalArgumentException("Invalid IP " + ipAddress);
        }
        ServiceManager.sCfg.mMyIP = ipAddress.getFormatedString();
        this.forcedAddress = presentationManager.createHostAddress(ipAddress, this.server.getListeningLocalPort());
        this.fireNetworkIPChanged();
    }

    public void addNetworkListener(NetworkListener networkListener) {
        this.listenerList.add(NetworkListener.class, networkListener);
    }

    public void removeNetworkListener(NetworkListener networkListener) {
        this.listenerList.remove(NetworkListener.class, networkListener);
    }

    public void addLoopbackListener(LoopbackListener loopbackListener) {
        this.listenerList.add(LoopbackListener.class, loopbackListener);
    }

    public void removeLoopbackListener(LoopbackListener loopbackListener) {
        this.listenerList.remove(LoopbackListener.class, loopbackListener);
    }

    public void fireConnectedToNetwork() {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                EventListener[] eventListenerArray = NetworkManager.this.listenerList.getListeners(class$phex$event$NetworkListener == null ? (class$phex$event$NetworkListener = NetworkManager.class$("phex.event.NetworkListener")) : class$phex$event$NetworkListener);
                for (int i = eventListenerArray.length - 1; i >= 0; --i) {
                    NetworkListener networkListener = (NetworkListener)eventListenerArray[i];
                    networkListener.connectedToNetwork();
                }
            }
        });
    }

    public void fireDisconnectedFromNetwork() {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                EventListener[] eventListenerArray = NetworkManager.this.listenerList.getListeners(class$phex$event$NetworkListener == null ? (class$phex$event$NetworkListener = NetworkManager.class$("phex.event.NetworkListener")) : class$phex$event$NetworkListener);
                for (int i = eventListenerArray.length - 1; i >= 0; --i) {
                    NetworkListener networkListener = (NetworkListener)eventListenerArray[i];
                    networkListener.disconnectedFromNetwork();
                }
            }
        });
    }

    public void fireNetworkIPChanged() {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                EventListener[] eventListenerArray = NetworkManager.this.listenerList.getListeners(class$phex$event$NetworkListener == null ? (class$phex$event$NetworkListener = NetworkManager.class$("phex.event.NetworkListener")) : class$phex$event$NetworkListener);
                for (int i = eventListenerArray.length - 1; i >= 0; --i) {
                    NetworkListener networkListener = (NetworkListener)eventListenerArray[i];
                    networkListener.networkIPChanged(NetworkManager.this.getLocalAddress());
                }
            }
        });
    }

    public void fireIncomingUriDownload(final String string) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                EventListener[] eventListenerArray = NetworkManager.this.listenerList.getListeners(class$phex$event$LoopbackListener == null ? (class$phex$event$LoopbackListener = NetworkManager.class$("phex.event.LoopbackListener")) : class$phex$event$LoopbackListener);
                for (int i = eventListenerArray.length - 1; i >= 0; --i) {
                    LoopbackListener loopbackListener = (LoopbackListener)eventListenerArray[i];
                    loopbackListener.incommingUriDownload(string);
                }
            }
        });
    }

    public void fireIncomingMagmaDownload(final String string) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                EventListener[] eventListenerArray = NetworkManager.this.listenerList.getListeners(class$phex$event$LoopbackListener == null ? (class$phex$event$LoopbackListener = NetworkManager.class$("phex.event.LoopbackListener")) : class$phex$event$LoopbackListener);
                for (int i = eventListenerArray.length - 1; i >= 0; --i) {
                    LoopbackListener loopbackListener = (LoopbackListener)eventListenerArray[i];
                    loopbackListener.incommingMagmaDownload(string);
                }
            }
        });
    }

    public void fireIncomingRSSDownload(final String string) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                EventListener[] eventListenerArray = NetworkManager.this.listenerList.getListeners(class$phex$event$LoopbackListener == null ? (class$phex$event$LoopbackListener = NetworkManager.class$("phex.event.LoopbackListener")) : class$phex$event$LoopbackListener);
                for (int i = eventListenerArray.length - 1; i >= 0; --i) {
                    LoopbackListener loopbackListener = (LoopbackListener)eventListenerArray[i];
                    loopbackListener.incommingRSSDownload(string);
                }
            }
        });
    }

    private static class Holder {
        protected static final NetworkManager manager = new NetworkManager();

        private Holder() {
        }
    }
}

