/*
 * Decompiled with CFR 0.152.
 */
package phex.connection;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.StringTokenizer;
import phex.common.HorizonTracker;
import phex.common.PongCache;
import phex.common.QueryRoutingTable;
import phex.common.ServiceManager;
import phex.common.ThreadPool;
import phex.common.address.AddressUtils;
import phex.common.address.DefaultDestAddress;
import phex.common.address.DestAddress;
import phex.common.address.IpAddress;
import phex.common.address.MalformedDestAddressException;
import phex.connection.ConnectionClosedException;
import phex.connection.ConnectionConstants;
import phex.connection.ConnectionRejectedException;
import phex.connection.NetworkManager;
import phex.connection.handshake.HandshakeHandler;
import phex.connection.handshake.HandshakeStatus;
import phex.host.CaughtHostsContainer;
import phex.host.Host;
import phex.host.HostManager;
import phex.http.HTTPHeader;
import phex.http.HTTPHeaderGroup;
import phex.http.HTTPProcessor;
import phex.msg.GUID;
import phex.msg.InvalidMessageException;
import phex.msg.Message;
import phex.msg.MessageProcessor;
import phex.msg.MsgHeader;
import phex.msg.MsgManager;
import phex.msg.PingMsg;
import phex.msg.PongMsg;
import phex.msg.PushRequestMsg;
import phex.msg.QueryMsg;
import phex.msg.QueryResponseMsg;
import phex.msg.QueryResponseRecord;
import phex.msg.RouteTableUpdateMsg;
import phex.msg.vendor.CapabilitiesVMsg;
import phex.msg.vendor.HopsFlowVMsg;
import phex.msg.vendor.MessagesSupportedVMsg;
import phex.msg.vendor.PushProxyAcknowledgementVMsg;
import phex.msg.vendor.PushProxyRequestVMsg;
import phex.msg.vendor.TCPConnectBackVMsg;
import phex.msg.vendor.VendorMsg;
import phex.net.OnlineObserver;
import phex.net.connection.Connection;
import phex.net.connection.ConnectionFactory;
import phex.net.presentation.PresentationManager;
import phex.query.QueryHistoryMonitor;
import phex.query.QueryManager;
import phex.security.PhexSecurityManager;
import phex.share.ShareFile;
import phex.share.ShareManager;
import phex.share.SharedFilesService;
import phex.statistic.MessageCountStatistic;
import phex.upload.PushWorker;
import phex.utils.HexConverter;
import phex.utils.Localizer;
import phex.utils.NLogger;
import phex.utils.QueryGUIDRoutingPair;
import phex.utils.VersionUtils;

public class ConnectionEngine
implements ConnectionConstants {
    private final HostManager hostMgr;
    private final ShareManager shareMgr;
    private final QueryHistoryMonitor queryHistory;
    private final SharedFilesService sharedFilesService;
    private final MsgManager messageMgr;
    private final NetworkManager networkMgr;
    private final PhexSecurityManager securityManager;
    private byte[] headerBuffer;
    private final Host connectedHost;
    private Connection connection;
    private HTTPHeaderGroup headersRead;
    private HTTPHeaderGroup headersSend;

    public ConnectionEngine(Host host) {
        this.connectedHost = host;
        this.connection = host.getConnection();
        this.shareMgr = ShareManager.getInstance();
        this.sharedFilesService = ShareManager.getInstance().getSharedFilesService();
        this.queryHistory = QueryManager.getInstance().getQueryHistoryMonitor();
        this.messageMgr = MsgManager.getInstance();
        this.hostMgr = HostManager.getInstance();
        this.networkMgr = NetworkManager.getInstance();
        this.securityManager = PhexSecurityManager.getInstance();
    }

    public void processIncomingData() throws IOException {
        this.headerBuffer = new byte[23];
        try {
            while (true) {
                Message message;
                MsgHeader msgHeader;
                block21: {
                    msgHeader = this.readHeader();
                    byte[] byArray = MessageProcessor.readMessageBody(this.connection, msgHeader.getDataLength());
                    this.connectedHost.incReceivedCount();
                    byte by = msgHeader.getTTL();
                    byte by2 = msgHeader.getHopsTaken();
                    if (by < 0 || by2 < 0) {
                        this.dropMessage(msgHeader, byArray, "TTL or hops below 0");
                        continue;
                    }
                    if (by2 > ServiceManager.sCfg.maxNetworkTTL) {
                        this.dropMessage(msgHeader, byArray, "Hops larger then maxNetworkTTL");
                        continue;
                    }
                    if (by >= ServiceManager.sCfg.maxNetworkTTL) {
                        msgHeader.setTTL((byte)(ServiceManager.sCfg.maxNetworkTTL - by2));
                    }
                    try {
                        message = MessageProcessor.createMessageFromBody(msgHeader, byArray);
                        if (message == null) {
                            this.dropMessage(msgHeader, byArray, "Unknown message type");
                        }
                        break block21;
                    }
                    catch (InvalidMessageException invalidMessageException) {
                        this.dropMessage(msgHeader, byArray, "Invalid message: " + invalidMessageException.getMessage());
                        NLogger.warn("IncomingMessages", (Object)invalidMessageException, (Throwable)invalidMessageException);
                    }
                    continue;
                }
                msgHeader.countHop();
                switch (msgHeader.getPayload()) {
                    case 0: {
                        this.handlePing((PingMsg)message);
                        break;
                    }
                    case 1: {
                        this.handlePong((PongMsg)message);
                        break;
                    }
                    case 64: {
                        this.handlePushRequest((PushRequestMsg)message);
                        break;
                    }
                    case -128: {
                        this.handleQuery((QueryMsg)message);
                        break;
                    }
                    case -127: {
                        this.handleQueryResponse((QueryResponseMsg)message);
                        break;
                    }
                    case 48: {
                        this.handleRouteTableUpdate((RouteTableUpdateMsg)message);
                        break;
                    }
                    case 49: 
                    case 50: {
                        this.handleVendorMessage((VendorMsg)message);
                    }
                }
            }
        }
        catch (IOException iOException) {
            NLogger.debug(ConnectionEngine.class, (Object)iOException, (Throwable)iOException);
            if (this.connectedHost.isConnected()) {
                this.connectedHost.setStatus(1, iOException.getMessage());
                this.hostMgr.disconnectHost(this.connectedHost);
            }
            throw iOException;
        }
        catch (Exception exception) {
            NLogger.warn(ConnectionEngine.class, (Object)exception, (Throwable)exception);
            if (this.connectedHost.isConnected()) {
                this.connectedHost.setStatus(1, exception.getMessage());
                this.hostMgr.disconnectHost(this.connectedHost);
            }
            throw new IOException("Exception occured: " + exception.getMessage());
        }
    }

    private void handlePing(PingMsg pingMsg) {
        if (NLogger.isDebugEnabled("IncomingMessages")) {
            NLogger.debug("IncomingMessages", (Object)("Received Ping: " + pingMsg.getDebugString() + " - " + pingMsg.getHeader().getDebugString()));
        }
        MessageCountStatistic.pingMsgInCounter.increment(1);
        MsgHeader msgHeader = pingMsg.getHeader();
        if (!this.messageMgr.checkAndAddToPingRoutingTable(msgHeader.getMsgID(), this.connectedHost)) {
            this.dropMessage(pingMsg, "Dropping already seen ping");
            return;
        }
        this.respondToPing(pingMsg);
    }

    private void respondToPing(PingMsg pingMsg) {
        Object object;
        Object object2;
        byte by;
        MsgHeader msgHeader = pingMsg.getHeader();
        byte by2 = msgHeader.getTTL();
        if (by2 + (by = msgHeader.getHopsTaken()) > 2 && !this.hostMgr.areIncommingSlotsAdvertised()) {
            return;
        }
        if (by == 1 && by2 == 1) {
            Host[] hostArray = this.hostMgr.getNetworkHostsContainer().getLeafConnections();
            for (int i = 0; i < hostArray.length; ++i) {
                object2 = hostArray[i].getHostAddress();
                object = PongMsg.createOtherLeafsOutgoingPong(msgHeader.getMsgID(), (byte)1, (byte)1, (DestAddress)object2);
                this.connectedHost.queueMessageToSend((Message)object);
            }
        }
        byte by3 = by;
        by = (byte)(by + 1);
        byte by4 = by3;
        if (by + by2 <= 2) {
            by4 = 1;
        }
        PongMsg pongMsg = PongMsg.createMyOutgoingPong(msgHeader.getMsgID(), by4);
        this.connectedHost.queueMessageToSend(pongMsg);
        object2 = PongCache.getInstance().getPongs();
        object = msgHeader.getMsgID();
        DestAddress destAddress = this.connectedHost.getHostAddress();
        IpAddress ipAddress = destAddress.getIpAddress();
        if (ipAddress == null) {
            return;
        }
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            pongMsg = (PongMsg)iterator.next();
            if (Arrays.equals(pongMsg.getIP(), ipAddress.getHostIP())) continue;
            this.connectedHost.queueMessageToSend(PongMsg.createFromCachePong((GUID)object, by4, pongMsg));
        }
    }

    private void handlePong(PongMsg pongMsg) {
        Object object;
        byte[] byArray;
        int n;
        if (NLogger.isDebugEnabled("IncomingMessages")) {
            NLogger.debug("IncomingMessages", (Object)("Received Pong: " + pongMsg.getDebugString() + " - " + pongMsg.getHeader().getDebugString()));
        }
        MessageCountStatistic.pongMsgInCounter.increment(1);
        HorizonTracker.getInstance().trackPong(pongMsg);
        MsgHeader msgHeader = pongMsg.getHeader();
        byte[] byArray2 = pongMsg.getIP();
        byte by = this.securityManager.controlHostIPAccess(byArray2);
        if (by == 3) {
            this.dropMessage(pongMsg, "IP access strongly denied.");
            return;
        }
        if (by == 1 && (n = (int)(this.hostMgr.getCaughtHostsContainer().addCaughtHost(pongMsg) ? 1 : 0)) != 0) {
            PongCache.getInstance().addPong(pongMsg);
        }
        n = pongMsg.getPort();
        byte by2 = pongMsg.getHeader().getHopsTaken();
        if (by2 == 1 && Arrays.equals(byArray = (object = this.connectedHost.getHostAddress()).getIpAddress().getHostIP(), byArray2)) {
            this.connectedHost.setFileCount(pongMsg.getFileCount());
            this.connectedHost.setTotalFileSize(pongMsg.getFileSizeInKB());
            int n2 = object.getPort();
            if (n2 != n) {
                object.setPort(n);
            }
        }
        if ((object = this.messageMgr.getPingRouting(msgHeader.getMsgID())) == null || object == Host.LOCAL_HOST) {
            return;
        }
        if (pongMsg.getHeader().getTTL() > 0) {
            ((Host)object).queueMessageToSend(pongMsg);
        }
    }

    private void handleQuery(QueryMsg queryMsg) {
        if (NLogger.isDebugEnabled("IncomingMessages")) {
            NLogger.debug("IncomingMessages", (Object)("Received Query: " + queryMsg.toString() + " - " + queryMsg.getHeader().getDebugString()));
        }
        MessageCountStatistic.queryMsgInCounter.increment(1);
        MsgHeader msgHeader = queryMsg.getHeader();
        if (!this.messageMgr.checkAndAddToQueryRoutingTable(msgHeader.getMsgID(), this.connectedHost)) {
            this.dropMessage(queryMsg, "Dropping already seen query");
            return;
        }
        if (this.connectedHost.isUltrapeerLeafConnection() && msgHeader.getHopsTaken() > 2) {
            this.dropMessage(queryMsg, "Dropping Query from Leaf with hops > 2.");
        }
        this.queryHistory.addSearchQuery(queryMsg);
        this.messageMgr.forwardQuery(queryMsg, this.connectedHost);
        ShareFile[] shareFileArray = this.shareMgr.handleQuery(queryMsg);
        if (shareFileArray.length == 0) {
            return;
        }
        this.replyToQuery(msgHeader, shareFileArray);
    }

    private void replyToQuery(MsgHeader msgHeader, ShareFile[] shareFileArray) {
        MsgHeader msgHeader2 = new MsgHeader(msgHeader.getMsgID(), -127, (byte)(msgHeader.getHopsTaken() + 1), 0, 0);
        int n = shareFileArray.length;
        if (n > 255) {
            n = 255;
        }
        ShareFile shareFile = null;
        QueryResponseRecord[] queryResponseRecordArray = new QueryResponseRecord[n];
        for (int i = 0; i < n; ++i) {
            QueryResponseRecord queryResponseRecord;
            shareFile = shareFileArray[i];
            queryResponseRecordArray[i] = queryResponseRecord = new QueryResponseRecord(shareFile.getFileIndex(), shareFile.getURN(), (int)shareFile.getFileSize(), shareFile.getFileName(), shareFile.getNetworkCreateTime(), shareFile.getAltLocContainer().getAltLocForQueryResponseRecord());
        }
        DestAddress destAddress = this.networkMgr.getLocalAddress();
        QueryResponseMsg queryResponseMsg = new QueryResponseMsg(msgHeader2, ServiceManager.sCfg.mProgramClientID, destAddress, Math.round((long)ServiceManager.sCfg.mUploadMaxBandwidth / 1024L * 8L), queryResponseRecordArray);
        this.connectedHost.queueMessageToSend(queryResponseMsg);
    }

    private void handleQueryResponse(QueryResponseMsg queryResponseMsg) {
        MessageCountStatistic.queryHitMsgInCounter.increment(1);
        DestAddress destAddress = queryResponseMsg.getDestAddress();
        byte by = this.securityManager.controlHostAddressAccess(destAddress);
        if (by == 3) {
            this.dropMessage(queryResponseMsg, "IP access strongly denied.");
            return;
        }
        if (by == 1) {
            this.messageMgr.processQueryResponse(this.connectedHost, queryResponseMsg);
        }
        this.messageMgr.addToPushRoutingTable(queryResponseMsg.getRemoteClientID(), this.connectedHost);
        MsgHeader msgHeader = queryResponseMsg.getHeader();
        QueryGUIDRoutingPair queryGUIDRoutingPair = this.messageMgr.getQueryRouting(msgHeader.getMsgID(), queryResponseMsg.getUniqueResultCount());
        if (queryGUIDRoutingPair == null) {
            return;
        }
        Host host = queryGUIDRoutingPair.getHost();
        if (msgHeader.getTTL() > 0 && host != Host.LOCAL_HOST && queryGUIDRoutingPair.getRoutedResultCount() < 200) {
            host.queueMessageToSend(queryResponseMsg);
        }
    }

    private void handleRouteTableUpdate(RouteTableUpdateMsg routeTableUpdateMsg) {
        MessageCountStatistic.totalInMsgCounter.increment(1);
        if (!this.connectedHost.isQueryRoutingSupported() && !this.connectedHost.isUPQueryRoutingSupported()) {
            this.dropMessage(routeTableUpdateMsg, "QRP not supported from host.");
            return;
        }
        QueryRoutingTable queryRoutingTable = this.connectedHost.getLastReceivedRoutingTable();
        if (queryRoutingTable == null) {
            queryRoutingTable = new QueryRoutingTable();
            this.connectedHost.setLastReceivedRoutingTable(queryRoutingTable);
        }
        try {
            queryRoutingTable.updateRouteTable(routeTableUpdateMsg);
            if (this.connectedHost.isUltrapeerLeafConnection()) {
                this.messageMgr.updateLocalQueryRoutingTable();
            }
        }
        catch (InvalidMessageException invalidMessageException) {
            this.dropMessage(routeTableUpdateMsg, "Invalid QRT update message.");
        }
    }

    private void handlePushRequest(PushRequestMsg pushRequestMsg) {
        MessageCountStatistic.pushMsgInCounter.increment(1);
        byte by = this.securityManager.controlHostAddressAccess(pushRequestMsg.getRequestAddress());
        if (by == 3) {
            this.dropMessage(pushRequestMsg, "IP access strongly denied.");
            return;
        }
        if (ServiceManager.sCfg.mProgramClientID.equals(pushRequestMsg.getClientGUID())) {
            if (by == 1) {
                new PushWorker(pushRequestMsg);
            }
            return;
        }
        Host host = this.messageMgr.getPushRouting(pushRequestMsg.getClientGUID());
        if (host == null) {
            return;
        }
        if (pushRequestMsg.getHeader().getTTL() > 0) {
            host.queueMessageToSend(pushRequestMsg);
        }
    }

    private void handleVendorMessage(VendorMsg vendorMsg) {
        if (NLogger.isDebugEnabled("IncomingMessages")) {
            NLogger.debug("IncomingMessages", (Object)("Received VendorMsg: " + vendorMsg.toString() + " - " + vendorMsg.getHeader().getDebugString()));
        }
        if (vendorMsg instanceof MessagesSupportedVMsg) {
            this.handleMessagesSupportedVMsg((MessagesSupportedVMsg)vendorMsg);
        } else if (vendorMsg instanceof TCPConnectBackVMsg) {
            this.handleTCPConnectBackVMsg((TCPConnectBackVMsg)vendorMsg);
        } else if (vendorMsg instanceof PushProxyRequestVMsg) {
            this.handlePushProxyRequestVMsg((PushProxyRequestVMsg)vendorMsg);
        } else if (vendorMsg instanceof PushProxyAcknowledgementVMsg) {
            this.handlePushProxyAcknowledgementVMsg((PushProxyAcknowledgementVMsg)vendorMsg);
        } else if (vendorMsg instanceof HopsFlowVMsg) {
            this.handleHopsFlowVMsg((HopsFlowVMsg)vendorMsg);
        } else if (vendorMsg instanceof CapabilitiesVMsg) {
            this.handleCapabilitiesVMsg((CapabilitiesVMsg)vendorMsg);
        }
    }

    private void handleMessagesSupportedVMsg(MessagesSupportedVMsg messagesSupportedVMsg) {
        this.connectedHost.setSupportedVMsgs(messagesSupportedVMsg);
        boolean bl = this.networkMgr.hasConnectedIncoming();
        if ((this.connectedHost.isLeafUltrapeerConnection() || bl && this.connectedHost.isUltrapeer()) && this.connectedHost.isPushProxySupported()) {
            PushProxyRequestVMsg pushProxyRequestVMsg = new PushProxyRequestVMsg();
            if (this.connectedHost.getVendor() != null && this.connectedHost.getVendor().indexOf("LimeWire") != -1) {
                pushProxyRequestVMsg.setVersion(1);
            }
            this.connectedHost.queueMessageToSend(pushProxyRequestVMsg);
        }
    }

    private void handleCapabilitiesVMsg(CapabilitiesVMsg capabilitiesVMsg) {
        this.connectedHost.setCapabilitiesVMsgs(capabilitiesVMsg);
    }

    private void handleTCPConnectBackVMsg(TCPConnectBackVMsg tCPConnectBackVMsg) {
        final int n = tCPConnectBackVMsg.getPort();
        final DestAddress destAddress = this.connectedHost.getHostAddress();
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Connection connection = null;
                try {
                    DefaultDestAddress defaultDestAddress = new DefaultDestAddress(destAddress.getHostName(), n);
                    connection = ConnectionFactory.createConnection(defaultDestAddress, 2000);
                    connection.write("\n\n".getBytes());
                    connection.flush();
                }
                catch (IOException iOException) {
                }
                catch (Exception exception) {
                    NLogger.error("OUTGOING_MESSAGES", (Object)exception, (Throwable)exception);
                }
                finally {
                    if (connection != null) {
                        connection.disconnect();
                    }
                }
            }
        };
        ThreadPool.getInstance().addJob(runnable, "TCPConnectBackJob");
    }

    private void handlePushProxyRequestVMsg(PushProxyRequestVMsg pushProxyRequestVMsg) {
        if (!this.connectedHost.isUltrapeerLeafConnection()) {
            return;
        }
        DestAddress destAddress = this.networkMgr.getLocalAddress();
        if (destAddress.getIpAddress() == null) {
            NLogger.warn("IncomingMessages", (Object)"Local address has no IP to use for PPAck.");
            return;
        }
        GUID gUID = pushProxyRequestVMsg.getHeader().getMsgID();
        PushProxyAcknowledgementVMsg pushProxyAcknowledgementVMsg = new PushProxyAcknowledgementVMsg(destAddress, gUID);
        this.connectedHost.queueMessageToSend(pushProxyAcknowledgementVMsg);
        this.messageMgr.addToPushRoutingTable(gUID, this.connectedHost);
    }

    private void handlePushProxyAcknowledgementVMsg(PushProxyAcknowledgementVMsg pushProxyAcknowledgementVMsg) {
        if (ServiceManager.sCfg.mProgramClientID.equals(pushProxyAcknowledgementVMsg.getHeader().getMsgID())) {
            this.connectedHost.setPushProxyAddress(pushProxyAcknowledgementVMsg.getHostAddress());
        }
    }

    private void handleHopsFlowVMsg(HopsFlowVMsg hopsFlowVMsg) {
        byte by = hopsFlowVMsg.getHopsValue();
        this.connectedHost.setHopsFlowLimit(by);
    }

    private void dropMessage(MsgHeader msgHeader, byte[] byArray, String string) {
        NLogger.info("IncomingMessages.Dropped", (Object)("Dropping message: " + string + " from: " + this.connectedHost));
        if (NLogger.isDebugEnabled("IncomingMessages.Dropped")) {
            NLogger.debug("IncomingMessages.Dropped", (Object)("Header: " + msgHeader.getDebugString() + " Body: " + " (" + HexConverter.toHexString(byArray, 0, msgHeader.getDataLength()) + ")."));
        }
        this.connectedHost.incDropCount();
        MessageCountStatistic.dropedMsgInCounter.increment(1);
    }

    private void dropMessage(Message message, String string) {
        NLogger.info("IncomingMessages.Dropped", (Object)("Dropping message: " + string + " from: " + this.connectedHost));
        if (NLogger.isDebugEnabled("IncomingMessages.Dropped")) {
            NLogger.debug("IncomingMessages.Dropped", (Object)("Header: [" + message.getHeader().getDebugString() + "] - Message: [" + message.toDebugString() + "]."));
        }
        this.connectedHost.incDropCount();
        MessageCountStatistic.dropedMsgInCounter.increment(1);
    }

    private MsgHeader readHeader() throws IOException {
        MsgHeader msgHeader = MessageProcessor.parseMessageHeader(this.connection, this.headerBuffer);
        if (msgHeader == null) {
            throw new ConnectionClosedException("Connection closed by remote host");
        }
        int n = msgHeader.getDataLength();
        if (n < 0) {
            throw new IOException("Negative body size. Disconnecting the remote host.");
        }
        if (n > ServiceManager.sCfg.maxMessageLength) {
            if (NLogger.isWarnEnabled(ConnectionEngine.class)) {
                byte[] byArray = MessageProcessor.readMessageBody(this.connection, 262144);
                String string = HexConverter.toHexString(byArray);
                NLogger.warn(ConnectionEngine.class, (Object)(this.connectedHost + " - Body too big. Header: " + msgHeader + "\nBody(256KB): " + string));
            }
            throw new IOException("Packet too big. Disconnecting the remote host.");
        }
        msgHeader.setArrivalTime(System.currentTimeMillis());
        msgHeader.setFromHost(this.connectedHost);
        return msgHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeOutgoingConnection() throws IOException {
        CapabilitiesVMsg capabilitiesVMsg;
        this.connectedHost.setStatus(2);
        this.connection = ConnectionFactory.createConnection(this.connectedHost.getHostAddress());
        OnlineObserver onlineObserver = NetworkManager.getInstance().getOnlineObserver();
        onlineObserver.markSuccessfulConnection();
        this.connectedHost.setConnection(this.connection);
        try {
            this.initializeOutgoingWith06();
            this.configureConnectionType(this.headersSend, this.headersRead);
            this.postHandshakeConfiguration(this.headersSend, this.headersRead);
            capabilitiesVMsg = null;
            if (this.headersRead != null) {
                this.handleXTryHeaders(this.headersRead);
                this.headersRead = null;
                this.headersSend = null;
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (this.headersRead != null) {
                this.handleXTryHeaders(this.headersRead);
                this.headersRead = null;
                this.headersSend = null;
            }
            throw throwable;
        }
        this.connectedHost.setStatus(4);
        this.hostMgr.addConnectedHost(this.connectedHost);
        this.messageMgr.pingHost(this.connectedHost, (byte)ServiceManager.sCfg.ttl);
        if (this.connectedHost.isVendorMessageSupported()) {
            MessagesSupportedVMsg messagesSupportedVMsg = MessagesSupportedVMsg.getMyMsgSupported();
            if (NLogger.isDebugEnabled("OUTGOING_MESSAGES")) {
                NLogger.debug("OUTGOING_MESSAGES", (Object)("Queueing MessagesSupportedVMsg: " + messagesSupportedVMsg.toString() + " - " + messagesSupportedVMsg.getHeader().getDebugString() + " - Host: " + this.connectedHost.toString()));
            }
            this.connectedHost.queueMessageToSend(messagesSupportedVMsg);
            capabilitiesVMsg = CapabilitiesVMsg.getMyCapabilitiesVMsg();
            if (NLogger.isDebugEnabled("OUTGOING_MESSAGES")) {
                NLogger.debug("OUTGOING_MESSAGES", (Object)("Queueing CapabilitiesVMsg: " + capabilitiesVMsg.toString() + " - " + capabilitiesVMsg.getHeader().getDebugString() + " - Host: " + this.connectedHost.toString()));
            }
            this.connectedHost.queueMessageToSend(capabilitiesVMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeIncomingConnection(String string) throws IOException {
        CapabilitiesVMsg capabilitiesVMsg;
        int n = string.lastIndexOf(47) + 1;
        String string2 = string.substring(n, string.length());
        try {
            if (string2.equals("0.4")) {
                this.initializeIncomingWith04();
            } else if (this.is06orHigher(string2)) {
                this.initializeIncomingWith06();
            }
            this.configureConnectionType(this.headersSend, this.headersRead);
            this.postHandshakeConfiguration(this.headersSend, this.headersRead);
            capabilitiesVMsg = null;
            if (this.headersRead != null) {
                this.handleXTryHeaders(this.headersRead);
                this.headersRead = null;
                this.headersSend = null;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (this.headersRead != null) {
                this.handleXTryHeaders(this.headersRead);
                this.headersRead = null;
                this.headersSend = null;
            }
            throw throwable;
        }
        this.connectedHost.setStatus(4);
        this.hostMgr.addIncomingHost(this.connectedHost);
        this.messageMgr.pingHost(this.connectedHost, (byte)ServiceManager.sCfg.ttl);
        if (this.connectedHost.isVendorMessageSupported()) {
            MessagesSupportedVMsg messagesSupportedVMsg = MessagesSupportedVMsg.getMyMsgSupported();
            if (NLogger.isDebugEnabled("OUTGOING_MESSAGES")) {
                NLogger.debug("OUTGOING_MESSAGES", (Object)("Queueing MessagesSupportedVMsg: " + messagesSupportedVMsg.toString() + " - " + messagesSupportedVMsg.getHeader().getDebugString() + " - Host: " + this.connectedHost.toString()));
            }
            this.connectedHost.queueMessageToSend(messagesSupportedVMsg);
            capabilitiesVMsg = CapabilitiesVMsg.getMyCapabilitiesVMsg();
            if (NLogger.isDebugEnabled("OUTGOING_MESSAGES")) {
                NLogger.debug("OUTGOING_MESSAGES", (Object)("Queueing CapabilitiesVMsg: " + capabilitiesVMsg.toString() + " - " + capabilitiesVMsg.getHeader().getDebugString() + " - Host: " + this.connectedHost.toString()));
            }
            this.connectedHost.queueMessageToSend(capabilitiesVMsg);
        }
    }

    private void initializeIncomingWith04() throws IOException {
        HandshakeHandler handshakeHandler = HandshakeHandler.createHandshakeHandler(this.connectedHost);
        HandshakeStatus handshakeStatus = handshakeHandler.createHandshakeResponse(new HandshakeStatus(200, "OK"), false);
        if (handshakeStatus.getStatusCode() != 200) {
            throw new IOException("Connection not accepted: " + handshakeStatus.getStatusCode() + " " + handshakeStatus.getStatusMessage());
        }
        this.sendStringToHost("GNUTELLA OK\n\n");
        this.headersRead = HTTPHeaderGroup.EMPTY_HEADERGROUP;
        this.headersSend = HTTPHeaderGroup.EMPTY_HEADERGROUP;
    }

    private void initializeIncomingWith06() throws IOException {
        this.headersRead = HTTPProcessor.parseHTTPHeaders(this.connection);
        if (NLogger.isDebugEnabled("IncomingMessages")) {
            NLogger.debug("IncomingMessages", (Object)(this.connectedHost + " - Connect headers: " + this.headersRead.buildHTTPHeaderString()));
        }
        this.configureRemoteHost(this.headersRead);
        HandshakeHandler handshakeHandler = HandshakeHandler.createHandshakeHandler(this.connectedHost);
        HandshakeStatus handshakeStatus = handshakeHandler.createHandshakeResponse(new HandshakeStatus(this.headersRead), false);
        this.headersSend = handshakeStatus.getResponseHeaders();
        this.sendStringToHost("GNUTELLA/0.6 " + handshakeStatus.getStatusCode() + " " + handshakeStatus.getStatusMessage() + "\r\n");
        String string = handshakeStatus.getResponseHeaders().buildHTTPHeaderString();
        this.sendStringToHost(string);
        this.sendStringToHost("\r\n");
        if (handshakeStatus.getStatusCode() != 200) {
            throw new IOException("Connection not accepted: " + handshakeStatus.getStatusCode() + " " + handshakeStatus.getStatusMessage());
        }
        HandshakeStatus handshakeStatus2 = HandshakeStatus.parseHandshakeResponse(this.connection);
        if (NLogger.isDebugEnabled("IncomingMessages")) {
            NLogger.debug("IncomingMessages", (Object)(this.connectedHost + " - Response Code: '" + handshakeStatus2.getStatusCode() + "'."));
            NLogger.debug("IncomingMessages", (Object)(this.connectedHost + " - Response Message: '" + handshakeStatus2.getStatusMessage() + "'."));
            NLogger.debug("IncomingMessages", (Object)(this.connectedHost + " - Response Headers: " + handshakeStatus2.getResponseHeaders().buildHTTPHeaderString()));
        }
        if (handshakeStatus2.getStatusCode() != 200) {
            throw new IOException("Host rejected connection: " + handshakeStatus2.getStatusCode() + " " + handshakeStatus2.getStatusMessage());
        }
        this.headersRead.replaceHeaders(handshakeStatus2.getResponseHeaders());
    }

    private void initializeOutgoingWith06() throws IOException {
        this.connectedHost.setStatus(2, Localizer.getString("Negotiate0_6Handshake"));
        String string = this.networkMgr.getGnutellaNetwork().getNetworkGreeting();
        String string2 = string + '/' + "0.6" + "\r\n";
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(string2);
        HandshakeHandler handshakeHandler = HandshakeHandler.createHandshakeHandler(this.connectedHost);
        HTTPHeaderGroup hTTPHeaderGroup = handshakeHandler.createOutgoingHandshakeHeaders();
        stringBuffer.append(hTTPHeaderGroup.buildHTTPHeaderString());
        stringBuffer.append("\r\n");
        this.headersSend = hTTPHeaderGroup;
        String string3 = stringBuffer.toString();
        this.sendStringToHost(string3);
        HandshakeStatus handshakeStatus = HandshakeStatus.parseHandshakeResponse(this.connection);
        this.headersRead = handshakeStatus.getResponseHeaders();
        if (NLogger.isDebugEnabled("IncomingMessages")) {
            NLogger.debug("IncomingMessages", (Object)(this.connectedHost + " - Response Code: '" + handshakeStatus.getStatusCode() + "'."));
            NLogger.debug("IncomingMessages", (Object)(this.connectedHost + " - Response Message: '" + handshakeStatus.getStatusMessage() + "'."));
            NLogger.debug("IncomingMessages", (Object)(this.connectedHost + " - Response Headers: " + this.headersRead.buildHTTPHeaderString()));
        }
        if (handshakeStatus.getStatusCode() != 200) {
            if (handshakeStatus.getStatusCode() == 503) {
                throw new ConnectionRejectedException(handshakeStatus.getStatusCode() + " " + handshakeStatus.getStatusMessage());
            }
            throw new ConnectionRejectedException("Gnutella 0.6 connection rejected. Status: " + handshakeStatus.getStatusCode() + " - " + handshakeStatus.getStatusMessage());
        }
        this.configureRemoteHost(this.headersRead);
        HandshakeStatus handshakeStatus2 = handshakeHandler.createHandshakeResponse(handshakeStatus, true);
        HTTPHeaderGroup hTTPHeaderGroup2 = handshakeStatus2.getResponseHeaders();
        this.headersSend.replaceHeaders(hTTPHeaderGroup2);
        this.sendStringToHost("GNUTELLA/0.6 " + handshakeStatus2.getStatusCode() + " " + handshakeStatus2.getStatusMessage() + "\r\n");
        String string4 = hTTPHeaderGroup2.buildHTTPHeaderString();
        this.sendStringToHost(string4);
        this.sendStringToHost("\r\n");
        if (handshakeStatus2.getStatusCode() != 200) {
            throw new IOException("Connection not accepted: " + handshakeStatus2.getStatusCode() + " " + handshakeStatus2.getStatusMessage());
        }
    }

    private void configureConnectionType(HTTPHeaderGroup hTTPHeaderGroup, HTTPHeaderGroup hTTPHeaderGroup2) {
        HTTPHeader hTTPHeader = hTTPHeaderGroup.getHeader("X-Ultrapeer");
        HTTPHeader hTTPHeader2 = hTTPHeaderGroup2.getHeader("X-Ultrapeer");
        if (hTTPHeader == null || hTTPHeader2 == null) {
            this.connectedHost.setConnectionType((byte)0);
        } else if (hTTPHeader.booleanValue()) {
            if (hTTPHeader2.booleanValue()) {
                this.connectedHost.setConnectionType((byte)2);
            } else {
                this.connectedHost.setConnectionType((byte)3);
            }
        } else if (hTTPHeader2.booleanValue()) {
            this.connectedHost.setConnectionType((byte)1);
        } else {
            this.connectedHost.setConnectionType((byte)0);
        }
    }

    private void handleXTryHeaders(HTTPHeaderGroup hTTPHeaderGroup) {
        HTTPHeader[] hTTPHeaderArray = hTTPHeaderGroup.getHeaders("X-Try");
        if (hTTPHeaderArray != null) {
            this.handleXTryHosts(hTTPHeaderArray, true);
        }
        if ((hTTPHeaderArray = hTTPHeaderGroup.getHeaders("X-Try-Ultrapeers")) != null) {
            this.handleXTryHosts(hTTPHeaderArray, false);
        }
    }

    private void handleXTryHosts(HTTPHeader[] hTTPHeaderArray, boolean bl) {
        short s = bl ? (short)2 : 1;
        CaughtHostsContainer caughtHostsContainer = this.hostMgr.getCaughtHostsContainer();
        for (int i = 0; i < hTTPHeaderArray.length; ++i) {
            StringTokenizer stringTokenizer = new StringTokenizer(hTTPHeaderArray[i].getValue(), ",");
            block6: while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken().trim();
                try {
                    DestAddress destAddress = PresentationManager.getInstance().createHostAddress(string, 6346);
                    byte by = this.securityManager.controlHostAddressAccess(destAddress);
                    switch (by) {
                        case 2: 
                        case 3: {
                            continue block6;
                        }
                    }
                    IpAddress ipAddress = destAddress.getIpAddress();
                    if (!bl && ipAddress != null && ipAddress.isSiteLocalIP()) {
                        s = 0;
                    }
                    caughtHostsContainer.addCaughtHost(destAddress, s);
                }
                catch (MalformedDestAddressException malformedDestAddressException) {}
            }
        }
    }

    private void configureRemoteHost(HTTPHeaderGroup hTTPHeaderGroup) {
        int n;
        Object object;
        HTTPHeader hTTPHeader = hTTPHeaderGroup.getHeader("User-Agent");
        if (hTTPHeader != null) {
            this.connectedHost.setVendor(hTTPHeader.getValue());
        }
        if (this.connectedHost.isIncomming()) {
            hTTPHeader = hTTPHeaderGroup.getHeader("Listen-IP");
            if (hTTPHeader == null) {
                hTTPHeader = hTTPHeaderGroup.getHeader("X-My-Address");
            }
            if (hTTPHeader != null) {
                object = this.connectedHost.getHostAddress();
                n = AddressUtils.parsePort(hTTPHeader.getValue());
                if (n > 0) {
                    object.setPort(n);
                }
            }
        }
        if ((hTTPHeader = hTTPHeaderGroup.getHeader("Remote-IP")) != null && (object = AddressUtils.parseIP(hTTPHeader.getValue())) != null) {
            IpAddress ipAddress = new IpAddress((byte[])object);
            DestAddress destAddress = PresentationManager.getInstance().createHostAddress(ipAddress, -1);
            this.networkMgr.updateLocalAddress(destAddress);
        }
        if ((hTTPHeader = hTTPHeaderGroup.getHeader("X-Query-Routing")) != null) {
            try {
                float f = Float.parseFloat(hTTPHeader.getValue());
                if (f >= 0.1f) {
                    this.connectedHost.setQueryRoutingSupported(true);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((hTTPHeader = hTTPHeaderGroup.getHeader("X-Ultrapeer-Query-Routing")) != null) {
            try {
                float f = Float.parseFloat(hTTPHeader.getValue());
                if (f >= 0.1f) {
                    this.connectedHost.setUPQueryRoutingSupported(true);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((hTTPHeader = hTTPHeaderGroup.getHeader("X-Dynamic-Querying")) != null) {
            try {
                float f = hTTPHeader.floatValue();
                if (f >= 0.1f) {
                    this.connectedHost.setDynamicQuerySupported(true);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        byte by = hTTPHeaderGroup.getByteHeaderValue("X-Max-TTL", (byte)4);
        this.connectedHost.setMaxTTL(by);
        n = hTTPHeaderGroup.getIntHeaderValue("X-Degree", 6);
        this.connectedHost.setUltrapeerDegree(n);
    }

    private void postHandshakeConfiguration(HTTPHeaderGroup hTTPHeaderGroup, HTTPHeaderGroup hTTPHeaderGroup2) throws IOException {
        HTTPHeader hTTPHeader;
        if (hTTPHeaderGroup.isHeaderValueContaining("Accept-Encoding", "deflate") && hTTPHeaderGroup2.isHeaderValueContaining("Content-Encoding", "deflate")) {
            this.connectedHost.activateInputInflation();
        }
        if (hTTPHeaderGroup2.isHeaderValueContaining("Accept-Encoding", "deflate") && hTTPHeaderGroup.isHeaderValueContaining("Content-Encoding", "deflate")) {
            this.connectedHost.activateOutputDeflation();
        }
        if ((hTTPHeader = hTTPHeaderGroup2.getHeader("Vendor-Message")) != null && !hTTPHeader.getValue().equals("")) {
            this.connectedHost.setVendorMessageSupported(true);
        }
    }

    private boolean is06orHigher(String string) {
        int n = VersionUtils.compare(string, "0.6");
        return n >= 0;
    }

    private void sendStringToHost(String string) throws IOException {
        NLogger.debug("OUTGOING_MESSAGES", (Object)(this.connectedHost + " - Send: " + string));
        byte[] byArray = string.getBytes();
        this.connection.write(byArray, 0, byArray.length);
        this.connection.flush();
    }
}

