/*
 * Decompiled with CFR 0.152.
 */
package phex.common.format;

import phex.utils.Localizer;

public final class TimeFormatUtils {
    private TimeFormatUtils() {
    }

    public static String formatSignificantElapsedTime(long l) {
        long l2 = l / 86400L;
        if (l2 > 0L) {
            Object[] objectArray = new Object[]{new Long(l2), new Integer((int)(l / 3600L % 24L))};
            return Localizer.getFormatedString("TimeFormatDH", objectArray);
        }
        int n = (int)(l / 3600L % 24L);
        if (n > 0) {
            Object[] objectArray = new Object[]{new Integer(n), new Integer((int)(l / 60L % 60L))};
            return Localizer.getFormatedString("TimeFormatHM", objectArray);
        }
        int n2 = (int)(l / 60L % 60L);
        if (n2 > 0) {
            Object[] objectArray = new Object[]{new Integer(n2), new Integer((int)(l % 60L))};
            return Localizer.getFormatedString("TimeFormatMS", objectArray);
        }
        int n3 = (int)(l % 60L);
        Object[] objectArray = new Object[]{new Integer(n3)};
        return Localizer.getFormatedString("TimeFormatS", objectArray);
    }

    public static String convertSecondsToTime(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = n / 86400;
        int n3 = n / 3600 % 24;
        int n4 = n / 60 % 60;
        int n5 = n % 60;
        if (n2 > 0) {
            stringBuffer.append(Integer.toString(n2));
            stringBuffer.append(":");
            if (n3 < 10) {
                stringBuffer.append("0");
            }
        }
        if (n2 > 0 || n3 > 0) {
            stringBuffer.append(Integer.toString(n3));
            stringBuffer.append(":");
            if (n4 < 10) {
                stringBuffer.append("0");
            }
        }
        stringBuffer.append(Integer.toString(n4));
        stringBuffer.append(":");
        if (n5 < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(Integer.toString(n5));
        return stringBuffer.toString();
    }
}

