/*
 * Decompiled with CFR 0.152.
 */
package phex.common.format;

import java.text.NumberFormat;
import phex.utils.Localizer;

public final class NumberFormatUtils {
    public static final NumberFormat integerFormat = NumberFormat.getIntegerInstance();
    public static final long ONE_KB = 1024L;
    public static final long ONE_MB = 0x100000L;
    public static final long ONE_GB = 0x40000000L;
    public static final long ONE_TB = 0x10000000000L;

    private NumberFormatUtils() {
    }

    public static String formatDecimal(double d, int n) {
        String string = String.valueOf(d);
        int n2 = string.indexOf(46);
        if (n2 == -1) {
            if (n != 0) {
                StringBuffer stringBuffer = new StringBuffer(string);
                stringBuffer.append(Localizer.getDecimalFormatSymbols().getDecimalSeparator());
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append("0");
                }
                string = stringBuffer.toString();
            }
        } else if (n == 0) {
            string = string.substring(0, n2);
        } else {
            int n3 = string.length() - n2 - 1;
            if (n3 < n) {
                StringBuffer stringBuffer = new StringBuffer(string);
                stringBuffer.setCharAt(n2, Localizer.getDecimalFormatSymbols().getDecimalSeparator());
                for (int i = 0; i < n - n3; ++i) {
                    stringBuffer.append("0");
                }
                string = stringBuffer.toString();
            } else if (n3 > n) {
                StringBuffer stringBuffer = new StringBuffer(string);
                stringBuffer.setCharAt(n2, Localizer.getDecimalFormatSymbols().getDecimalSeparator());
                string = stringBuffer.substring(0, n2 + n + 1);
            }
        }
        return string;
    }

    public static String formatSize(long l) {
        return integerFormat.format(l);
    }

    public static String formatFullByteSize(long l) {
        return integerFormat.format(l) + " " + Localizer.getString("BytesToken");
    }

    public static String formatSignificantByteSize(double d) {
        int n;
        double d2;
        String string;
        if (d < 1024.0) {
            string = Localizer.getString("BytesToken");
            d2 = 1.0;
            n = 0;
        } else if (d < 1048576.0) {
            string = Localizer.getString("KBToken");
            d2 = 1024.0;
            n = 1;
        } else if (d < 1.073741824E9) {
            string = Localizer.getString("MBToken");
            d2 = 1048576.0;
            n = 1;
        } else if (d < 1.099511627776E12) {
            string = Localizer.getString("GBToken");
            d2 = 1.073741824E9;
            n = 2;
        } else {
            string = Localizer.getString("TBToken");
            d2 = 1.099511627776E12;
            n = 3;
        }
        double d3 = d / d2;
        String string2 = NumberFormatUtils.formatDecimal(d3, n);
        return string2 + " " + string;
    }

    public static String formatSignificantByteSize(Number number) {
        return NumberFormatUtils.formatSignificantByteSize(number.doubleValue());
    }
}

