/*
 * Decompiled with CFR 0.152.
 */
package phex.common.format;

import phex.common.format.NumberFormatUtils;
import phex.utils.Localizer;

public class HostSpeedFormatUtils {
    public static final int SPEED_MODEM = 56;
    public static final int SPEED_ISDN = 64;
    public static final int SPEED_DualISDN = 128;
    public static final int SPEED_CableDSL1 = 256;
    public static final int SPEED_CableDSL2 = 512;
    public static final int SPEED_CableDSL3 = 768;
    public static final int SPEED_T1 = 1544;
    public static final int SPEED_10LAN = 10000;
    public static final int SPEED_T3 = 44736;
    public static final int SPEED_100LAN = 100000;
    private static final String SPEED_STRING_MODEM = Localizer.getString("HostSpeed_Modem");
    private static final String SPEED_STRING_DSL = Localizer.getString("HostSpeed_DSLCable");
    private static final String SPEED_STRING_T1 = Localizer.getString("HostSpeed_T1");
    private static final String SPEED_STRING_T3 = Localizer.getString("HostSpeed_T3");
    private static final String SPEED_KBITSSEC_POSTFIX = Localizer.getString("HostSpeed_KbPerSec_Postfix");

    public static String formatHostSpeed(long l) {
        StringBuffer stringBuffer = new StringBuffer(22);
        stringBuffer.append(NumberFormatUtils.formatDecimal(l, 0));
        stringBuffer.append(SPEED_KBITSSEC_POSTFIX);
        stringBuffer.append(" (");
        if (l <= 56L) {
            stringBuffer.append(SPEED_STRING_MODEM);
        } else if (l <= 512L) {
            stringBuffer.append(SPEED_STRING_DSL);
        } else if (l <= 1544L) {
            stringBuffer.append(SPEED_STRING_T1);
        } else {
            stringBuffer.append(SPEED_STRING_T3);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

