/*
 * Decompiled with CFR 0.152.
 */
package phex.common.file;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import phex.common.file.ManagedFile;
import phex.common.file.ManagedFileException;
import phex.utils.DirectByteBuffer;
import phex.utils.DirectByteBufferProvider;
import phex.utils.NLogger;

public class ManagedFileInputStream
extends InputStream {
    private DirectByteBuffer buffer;
    private ManagedFile managedFile;
    private long inputOffset;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ManagedFileInputStream(ManagedFile managedFile, long l) {
        this.managedFile = managedFile;
        this.inputOffset = l;
        this.buffer = DirectByteBufferProvider.requestBuffer(65536);
        this.buffer.flip();
    }

    public int read() throws IOException {
        ByteBuffer byteBuffer = this.buffer.getInternalBuffer();
        if (!byteBuffer.hasRemaining()) {
            this.fill();
        }
        if (!byteBuffer.hasRemaining()) {
            return -1;
        }
        byte by = byteBuffer.get();
        if (NLogger.isDebugEnabled(ManagedFileInputStream.class)) {
            NLogger.debug(ManagedFileInputStream.class, (Object)("Read: " + (char)by));
        }
        return by;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        if ((n | n2 | n + n2 | byArray.length - (n + n2)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        ByteBuffer byteBuffer = this.buffer.getInternalBuffer();
        if (!byteBuffer.hasRemaining()) {
            this.fill();
        }
        if (!byteBuffer.hasRemaining()) {
            return -1;
        }
        for (n3 = 0; n3 < n2 && byteBuffer.hasRemaining(); n3 += n4) {
            n4 = Math.min(n2 - n3, byteBuffer.remaining());
            byteBuffer.get(byArray, n + n3, n4);
            if (byteBuffer.hasRemaining()) continue;
            this.fill();
        }
        if (NLogger.isDebugEnabled(ManagedFileInputStream.class)) {
            NLogger.debug(ManagedFileInputStream.class, (Object)("Read: " + new String(byArray, n, n3)));
        }
        return n3;
    }

    public int available() throws IOException {
        ByteBuffer byteBuffer = this.buffer.getInternalBuffer();
        if (!byteBuffer.hasRemaining()) {
            this.fill();
        }
        return byteBuffer.remaining();
    }

    private void fill() throws IOException {
        ByteBuffer byteBuffer = this.buffer.getInternalBuffer();
        if (!$assertionsDisabled && byteBuffer.hasRemaining()) {
            throw new AssertionError();
        }
        byteBuffer.clear();
        try {
            this.managedFile.read(this.buffer, this.inputOffset);
        }
        catch (ManagedFileException managedFileException) {
            IOException iOException = new IOException("Cause: " + managedFileException.getMessage());
            iOException.initCause(managedFileException);
            throw iOException;
        }
        byteBuffer.flip();
        this.inputOffset += (long)byteBuffer.limit();
    }

    public void close() throws IOException {
        this.buffer.release();
    }

    static {
        $assertionsDisabled = !ManagedFileInputStream.class.desiredAssertionStatus();
    }
}

