/*
 * Decompiled with CFR 0.152.
 */
package phex.common.file;

import edu.oswego.cs.dl.util.concurrent.ReentrantLock;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import phex.common.file.FileManager;
import phex.common.file.ManagedFileException;
import phex.common.file.ReadOnlyManagedFile;
import phex.utils.DirectByteBuffer;
import phex.utils.NLogger;

public class ManagedFile
implements ReadOnlyManagedFile {
    private static final int MAX_WRITE_TRIES = 10;
    private static final int WRITE_RETRY_DELAY = 100;
    public static final int READ_ONLY_ACCESS = 0;
    public static final int READ_WRITE_ACCESS = 1;
    private ReentrantLock lock;
    private File fsFile;
    private int accessMode;
    private RandomAccessFile raFile;

    public ManagedFile(File file) {
        this.fsFile = file;
        this.lock = new ReentrantLock();
    }

    public void acquireFileLock() throws ManagedFileException {
        try {
            NLogger.debug(ManagedFile.class, (Object)("Acquire file lock " + this));
            this.lock.acquire();
            NLogger.debug(ManagedFile.class, (Object)("Acquired file lock " + this));
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new ManagedFileException("locking failed: interrupted", interruptedException);
        }
    }

    public void releaseFileLock() {
        NLogger.debug(ManagedFile.class, (Object)("Releasing " + this));
        this.lock.release();
    }

    public File getFile() {
        return this.fsFile;
    }

    public void setAccessMode(int n) throws ManagedFileException {
        if (this.accessMode == 0 && n == 1) {
            this.closeFile();
        }
        this.accessMode = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkOpenFile() throws ManagedFileException {
        try {
            this.lock.acquire();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new ManagedFileException("open failes: interrupted", interruptedException);
        }
        try {
            if (this.raFile != null) {
                FileManager.getInstance().trackFileInUse(this);
                return;
            }
            FileManager.getInstance().trackFileOpen(this);
            try {
                this.raFile = new RandomAccessFile(this.fsFile, this.accessMode == 0 ? "r" : "rwd");
            }
            catch (Exception exception) {
                throw new ManagedFileException("failed to open", exception);
            }
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeFile() throws ManagedFileException {
        if (this.raFile == null) {
            return;
        }
        try {
            this.lock.acquire();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new ManagedFileException("close failes: interrupted", interruptedException);
        }
        try {
            try {
                NLogger.debug("ManagedFile", (Object)"Closing file.");
                this.raFile.close();
            }
            catch (Exception exception) {
                throw new ManagedFileException("failed to close", exception);
            }
            Object var3_3 = null;
            this.raFile = null;
            FileManager.getInstance().trackFileClose(this);
            this.lock.release();
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.raFile = null;
            FileManager.getInstance().trackFileClose(this);
            this.lock.release();
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(DirectByteBuffer directByteBuffer, long l) throws ManagedFileException {
        try {
            this.lock.acquire();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new ManagedFileException("write failes: interrupted", interruptedException);
        }
        try {
            this.checkOpenFile();
            if (this.raFile == null) {
                throw new ManagedFileException("write failes: raFile null");
            }
            FileChannel fileChannel = this.raFile.getChannel();
            if (!fileChannel.isOpen()) {
                throw new ManagedFileException("write failes: not open");
            }
            fileChannel.position(l);
            ByteBuffer byteBuffer = directByteBuffer.getInternalBuffer();
            int n = 0;
            while (byteBuffer.position() != byteBuffer.limit()) {
                int n2 = fileChannel.write(byteBuffer);
                if (n2 > 0) {
                    n = 0;
                    continue;
                }
                if (n >= 10) {
                    throw new ManagedFileException("write failes: max retries");
                }
                try {
                    Thread.sleep(100 * n);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    throw new ManagedFileException("write failes: interrupted");
                    return;
                }
            }
        }
        catch (Exception exception) {
            throw new ManagedFileException("write fails", exception);
        }
        finally {
            this.lock.release();
        }
    }

    public void read(DirectByteBuffer directByteBuffer, long l) throws ManagedFileException {
        try {
            this.lock.acquire();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new ManagedFileException("read failes: interrupted", interruptedException);
        }
        try {
            this.checkOpenFile();
            if (this.raFile == null) {
                throw new ManagedFileException("read failes: raFile null");
            }
            FileChannel fileChannel = this.raFile.getChannel();
            if (!fileChannel.isOpen()) {
                throw new ManagedFileException("read failes: not open");
            }
            fileChannel.position(l);
            ByteBuffer byteBuffer = directByteBuffer.getInternalBuffer();
            while (fileChannel.position() < fileChannel.size() && byteBuffer.hasRemaining()) {
                fileChannel.read(byteBuffer);
            }
        }
        catch (Exception exception) {
            throw new ManagedFileException("read fails", exception);
        }
        finally {
            this.lock.release();
        }
    }

    public void setLength(long l) throws ManagedFileException {
        try {
            this.lock.acquire();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new ManagedFileException("read failes: interrupted", interruptedException);
        }
        try {
            this.checkOpenFile();
            if (this.raFile == null) {
                throw new ManagedFileException("read failes: raFile null");
            }
            this.raFile.setLength(l);
        }
        catch (Exception exception) {
            throw new ManagedFileException("read fails", exception);
        }
        finally {
            this.lock.release();
        }
    }

    public String toString() {
        return super.toString() + ",File:" + this.fsFile + ",access:" + this.accessMode;
    }
}

