/*
 * Decompiled with CFR 0.152.
 */
package phex.common.bandwidth;

import phex.common.AbstractManager;
import phex.common.ServiceManager;
import phex.common.bandwidth.BandwidthController;

public class BandwidthManager
extends AbstractManager {
    private BandwidthController phexBandwidthController;
    private BandwidthController networkBandwidthController;
    private BandwidthController downloadBandwidthController;
    private BandwidthController uploadBandwidthController;

    public void setDownloadBandwidth(int n) {
        ServiceManager.sCfg.mDownloadMaxBandwidth = n;
        this.downloadBandwidthController.setThrottlingRate(n);
    }

    public void setNetworkBandwidth(int n) {
        ServiceManager.sCfg.mNetMaxRate = n;
        this.networkBandwidthController.setThrottlingRate(n);
    }

    public void setPhexTotalBandwidth(int n) {
        ServiceManager.sCfg.maxTotalBandwidth = n;
        this.phexBandwidthController.setThrottlingRate(n);
    }

    public void setUploadBandwidth(int n) {
        ServiceManager.sCfg.mUploadMaxBandwidth = n;
        this.uploadBandwidthController.setThrottlingRate(n);
    }

    public BandwidthController getPhexBandwidthController() {
        return this.phexBandwidthController;
    }

    public BandwidthController getNetworkBandwidthController() {
        return this.networkBandwidthController;
    }

    public BandwidthController getDownloadBandwidthController() {
        return this.downloadBandwidthController;
    }

    public BandwidthController getUploadBandwidthController() {
        return this.uploadBandwidthController;
    }

    public static BandwidthManager getInstance() {
        return Holder.manager;
    }

    public boolean initialize() {
        this.phexBandwidthController = BandwidthController.acquireBandwidthController("PhexThrottle", ServiceManager.sCfg.maxTotalBandwidth);
        this.phexBandwidthController.activateShortTransferAvg(1000, 5);
        this.phexBandwidthController.activateLongTransferAvg(2000, 90);
        this.networkBandwidthController = BandwidthController.acquireBandwidthController("NetworkThrottle", ServiceManager.sCfg.mNetMaxRate);
        this.networkBandwidthController.activateShortTransferAvg(1000, 5);
        this.networkBandwidthController.activateLongTransferAvg(2000, 90);
        this.networkBandwidthController.linkControllerIntoChain(this.phexBandwidthController);
        this.downloadBandwidthController = BandwidthController.acquireBandwidthController("DownloadThrottle", ServiceManager.sCfg.mDownloadMaxBandwidth);
        this.downloadBandwidthController.activateShortTransferAvg(1000, 5);
        this.downloadBandwidthController.activateLongTransferAvg(2000, 90);
        this.downloadBandwidthController.linkControllerIntoChain(this.phexBandwidthController);
        this.uploadBandwidthController = BandwidthController.acquireBandwidthController("UploadThrottle", ServiceManager.sCfg.mUploadMaxBandwidth);
        this.uploadBandwidthController.activateShortTransferAvg(1000, 5);
        this.uploadBandwidthController.activateLongTransferAvg(2000, 90);
        this.uploadBandwidthController.linkControllerIntoChain(this.phexBandwidthController);
        return true;
    }

    public boolean onPostInitialization() {
        return true;
    }

    public void startupCompletedNotify() {
    }

    public void shutdown() {
        BandwidthController.releaseController(this.downloadBandwidthController);
        BandwidthController.releaseController(this.uploadBandwidthController);
        BandwidthController.releaseController(this.networkBandwidthController);
        BandwidthController.releaseController(this.phexBandwidthController);
    }

    private static class Holder {
        protected static final BandwidthManager manager = new BandwidthManager();

        private Holder() {
        }
    }
}

