/*
 * Decompiled with CFR 0.152.
 */
package phex.common.address;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Security;
import java.util.Arrays;
import phex.common.address.AddressUtils;
import phex.common.address.DestAddress;
import phex.common.address.IpAddress;
import phex.connection.NetworkManager;
import phex.utils.NLogger;

public class DefaultDestAddress
implements DestAddress {
    public static final int DEFAULT_PORT = 6346;
    private int hash = 0;
    private String hostName;
    private IpAddress ipAddress;
    private int port;
    private long lastIpLookupTime = -1L;

    public DefaultDestAddress(String string, int n) {
        if (string == null) {
            throw new NullPointerException("Host name is null");
        }
        if (AddressUtils.isIPHostName(string)) {
            this.ipAddress = new IpAddress(AddressUtils.parseIP(string));
        } else {
            this.hostName = string;
        }
        this.port = n;
    }

    public DefaultDestAddress(IpAddress ipAddress, int n) {
        if (ipAddress == null) {
            throw new NullPointerException("Null ipAddress not allowed.");
        }
        this.ipAddress = ipAddress;
        this.port = n;
    }

    public DefaultDestAddress(byte[] byArray, int n) {
        if (byArray == null) {
            throw new NullPointerException("Host ip is null");
        }
        this.ipAddress = new IpAddress(byArray);
        this.port = n;
    }

    public String getHostName() {
        if (this.hostName == null) {
            return this.ipAddress.getFormatedString();
        }
        return this.hostName;
    }

    public boolean isIpHostName() {
        if (this.hostName == null) {
            return true;
        }
        if (this.ipAddress == null) {
            return false;
        }
        return this.hostName.equals(this.ipAddress.getFormatedString());
    }

    public String getFullHostName() {
        StringBuffer stringBuffer = new StringBuffer(21);
        stringBuffer.append(this.getHostName());
        stringBuffer.append(':');
        stringBuffer.append(this.port);
        return stringBuffer.toString();
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
        this.hash = 0;
    }

    public IpAddress getIpAddress() {
        if (this.ipAddress == null || this.lastIpLookupTime > 0L && this.lastIpLookupTime + 60000L < System.currentTimeMillis()) {
            try {
                NLogger.debug(DefaultDestAddress.class, (Object)("Performing IP lookup " + this.hostName));
                byte[] byArray = InetAddress.getByName(this.hostName).getAddress();
                this.ipAddress = new IpAddress(byArray);
                this.lastIpLookupTime = System.currentTimeMillis();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return this.ipAddress;
    }

    public boolean equals(Object object) {
        if (object instanceof DefaultDestAddress) {
            return this.equals((DefaultDestAddress)object);
        }
        return false;
    }

    public boolean equals(DestAddress destAddress) {
        if (destAddress == null) {
            return false;
        }
        if (this.ipAddress != null && destAddress.getIpAddress() != null) {
            return this.ipAddress.equals(destAddress.getIpAddress()) && this.port == destAddress.getPort();
        }
        return this.getHostName().equals(destAddress.getHostName()) && this.port == destAddress.getPort();
    }

    public boolean equals(byte[] byArray, int n) {
        if (this.ipAddress != null) {
            return Arrays.equals(this.ipAddress.getHostIP(), byArray) && this.port == n;
        }
        return this.getHostName().equals(AddressUtils.ip2string(byArray)) && this.port == n;
    }

    public int hashCode() {
        if (this.hash == 0) {
            int n = 0;
            n = 31 * n + this.port;
            n = this.ipAddress != null ? 31 * n + this.ipAddress.hashCode() : 127 * n + this.hostName.hashCode();
            this.hash = n;
        }
        return this.hash;
    }

    public String getCountryCode() {
        if (this.ipAddress != null) {
            return this.ipAddress.getCountryCode();
        }
        return null;
    }

    public boolean isLocalHost() {
        DestAddress destAddress = NetworkManager.getInstance().getLocalAddress();
        if (this.getIpAddress().isLocalAddress()) {
            return true;
        }
        return destAddress.equals(this);
    }

    public boolean isSiteLocalAddress() {
        return this.getIpAddress().isSiteLocalIP();
    }

    public boolean isValidAddress() {
        return AddressUtils.isPortInRange(this.port) && this.getIpAddress() != null && this.getIpAddress().isValidIP();
    }

    public String toString() {
        return this.getFullHostName();
    }

    static {
        Security.setProperty("networkaddress.cache.ttl", "120");
        Security.setProperty("networkaddress.cache.negative.ttl", "120");
    }
}

