/*
 * Decompiled with CFR 0.152.
 */
package phex.common.address;

import phex.common.address.DestAddress;
import phex.common.address.IpAddress;
import phex.common.address.MalformedDestAddressException;
import phex.net.presentation.PresentationManager;
import phex.security.PhexSecurityManager;

public class AddressUtils {
    static final /* synthetic */ boolean $assertionsDisabled;

    public static String ip2string(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("Ip is null!");
        }
        if (!$assertionsDisabled && byArray.length != 4) {
            throw new AssertionError();
        }
        return (byArray[0] & 0xFF) + "." + (byArray[1] & 0xFF) + "." + (byArray[2] & 0xFF) + "." + (byArray[3] & 0xFF);
    }

    public static boolean isIPHostName(String string) {
        int n = string.indexOf(58);
        if (n != -1) {
            string = string.substring(0, n);
        }
        char[] cArray = string.toCharArray();
        int n2 = 0;
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c < '0' || c > '9') {
                return false;
            }
            while (c != '.') {
                if (c < '0' || c > '9') {
                    return false;
                }
                if (++i >= cArray.length) break;
                c = cArray[i];
            }
            ++n2;
        }
        return n2 == 4 && !string.endsWith(".");
    }

    public static DestAddress parseAndValidateAddress(String string, boolean bl) throws MalformedDestAddressException {
        byte[] byArray = AddressUtils.parseIP(string);
        if (byArray == null) {
            throw new MalformedDestAddressException("Invalid IP: " + string);
        }
        int n = AddressUtils.parsePort(string);
        if (n == -1) {
            n = 6346;
        } else if (!AddressUtils.isPortInRange(n)) {
            throw new MalformedDestAddressException("Port out of range: " + string);
        }
        IpAddress ipAddress = new IpAddress(byArray);
        DestAddress destAddress = PresentationManager.getInstance().createHostAddress(ipAddress, n);
        if (!destAddress.isValidAddress()) {
            throw new MalformedDestAddressException("Invalid IP: " + string);
        }
        if (!bl && destAddress.isSiteLocalAddress()) {
            throw new MalformedDestAddressException("Private IP: " + string);
        }
        byte by = PhexSecurityManager.getInstance().controlHostIPAccess(destAddress.getIpAddress().getHostIP());
        switch (by) {
            case 2: 
            case 3: {
                throw new MalformedDestAddressException("Host access denied: " + string);
            }
        }
        return destAddress;
    }

    public static byte[] parseIntIP(String string) {
        long l = Long.parseLong(string);
        byte[] byArray = new byte[]{(byte)(l >>> 24 & 0xFFL), (byte)(l >>> 16 & 0xFFL), (byte)(l >>> 8 & 0xFFL), (byte)(l & 0xFFL)};
        return byArray;
    }

    public static byte[] parseIP(String string) {
        int n = string.indexOf(58);
        if (n != -1) {
            string = string.substring(0, n);
        }
        char[] cArray = string.toCharArray();
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c < '0' || c > '9') {
                return null;
            }
            int n4 = 0;
            while (c != '.') {
                if (c < '0' || c > '9') {
                    return null;
                }
                n4 = n4 * 10 + c - 48;
                if (++i >= cArray.length) break;
                c = cArray[i];
            }
            if (n4 > 255) {
                return null;
            }
            n2 = (n2 << 8) + n4;
            ++n3;
        }
        if (n3 != 4 || string.endsWith(".")) {
            return null;
        }
        byte[] byArray = new byte[]{(byte)(n2 >>> 24 & 0xFF), (byte)(n2 >>> 16 & 0xFF), (byte)(n2 >>> 8 & 0xFF), (byte)(n2 & 0xFF)};
        return byArray;
    }

    public static int parsePort(String string) {
        char c;
        int n = string.indexOf(58);
        if (n == -1) {
            return -1;
        }
        String string2 = string.substring(n + 1);
        char[] cArray = string2.toCharArray();
        int n2 = 0;
        for (int i = 0; i < cArray.length && (c = cArray[i]) >= '0' && c <= '9'; ++i) {
            n2 = n2 * 10 + c - 48;
        }
        if (!AddressUtils.isPortInRange(n2)) {
            return -1;
        }
        return n2;
    }

    public static String toIntValueString(byte[] byArray) {
        int n = byArray[3] & 0xFF;
        int n2 = byArray[2] << 8 & 0xFF00;
        int n3 = byArray[1] << 16 & 0xFF0000;
        int n4 = byArray[0] << 24;
        long l = (long)(n4 | n3 | n2 | n) & 0xFFFFFFFFL;
        return String.valueOf(l);
    }

    public static boolean isPortInRange(int n) {
        return (n & 0xFFFF0000) == 0 && n != 0;
    }

    static {
        $assertionsDisabled = !AddressUtils.class.desiredAssertionStatus();
    }
}

