/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

import java.util.Locale;
import phex.utils.URLCodecUtils;

public class URN {
    public static final String SHA1 = "sha1";
    public static final String BITPRINT = "bitprint";
    public static final String URN_PREFIX = "urn:";
    private int hashCode = -1;
    private String urnString;
    private String urnNID;
    private String urnNSS;

    public URN(String string) {
        if (string.length() < 4) {
            throw new IllegalArgumentException("URN not valid: " + string);
        }
        String string2 = string.substring(0, 4).toLowerCase(Locale.US);
        if (!string2.equals(URN_PREFIX)) {
            throw new IllegalArgumentException("URN not valid: " + string);
        }
        int n = string.indexOf(58, 4);
        if (n == -1) {
            throw new IllegalArgumentException("URN not valid: " + string);
        }
        this.urnNID = string.substring(4, n);
        if (!URN.isValidNamespaceIdentifier(this.urnNID)) {
            throw new IllegalArgumentException("URN not valid (NID): " + string);
        }
        this.urnNSS = string.substring(n + 1, string.length());
        if (!URN.isValidNamespaceSpecificString(this.urnNSS)) {
            throw new IllegalArgumentException("URN not valid (NSS): " + string);
        }
        this.urnString = string;
    }

    public boolean isSha1Nid() {
        return SHA1.equalsIgnoreCase(this.urnNID);
    }

    public String getNamespaceSpecificString() {
        return this.urnNSS;
    }

    public String getSHA1Nss() {
        if (SHA1.equalsIgnoreCase(this.urnNID)) {
            return this.urnNSS;
        }
        if (BITPRINT.equalsIgnoreCase(this.urnNID)) {
            return this.urnNSS.substring(0, 32);
        }
        return null;
    }

    public String getAsString() {
        return this.urnString;
    }

    public boolean equals(Object object) {
        if (object instanceof URN) {
            return this.equals((URN)object);
        }
        return false;
    }

    public boolean equals(URN uRN) {
        if (this.urnNID.equalsIgnoreCase(uRN.urnNID)) {
            return uRN.urnString.equalsIgnoreCase(this.urnString);
        }
        String string = this.getSHA1Nss();
        if (string == null) {
            throw new RuntimeException("Cant compare URNs");
        }
        return string.equals(uRN.getSHA1Nss());
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = 3 * (this.urnString.hashCode() + this.getClass().hashCode());
        }
        return this.hashCode;
    }

    public static boolean isValidURN(String string) {
        if (string.length() < 4) {
            return false;
        }
        String string2 = string.substring(0, 4).toLowerCase(Locale.US);
        if (!string2.equals(URN_PREFIX)) {
            return false;
        }
        int n = string.indexOf(58, 4);
        if (n == -1) {
            return false;
        }
        String string3 = string.substring(4, n);
        if (!URN.isValidNamespaceIdentifier(string3)) {
            return false;
        }
        String string4 = string.substring(n + 1, string.length());
        return URN.isValidNamespaceSpecificString(string4);
    }

    public static boolean isValidNamespaceSpecificString(String string) {
        int n = string.length();
        return n == 32 || n == 72;
    }

    public static boolean isValidNamespaceIdentifier(String string) {
        String string2 = string.toLowerCase(Locale.US);
        if (string2.equals(SHA1)) {
            return true;
        }
        return string2.equals(BITPRINT);
    }

    public static URN parseURNFromUriRes(String string) {
        String string2;
        String string3 = string.toLowerCase(Locale.US);
        if (string3.startsWith("/uri-res/n2r?urn:") && URN.isValidURN(string2 = URLCodecUtils.decodeURL(string.substring(13)))) {
            URN uRN = new URN(string2);
            return uRN;
        }
        return null;
    }
}

