/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.commons.lang.SystemUtils;
import phex.utils.NLogger;

public class ThreadTracking {
    public static ThreadGroup threadPoolGroup;
    public static ThreadGroup rootThreadGroup;
    private static ThreadGroup systemGroup;

    public static void initialize() {
        systemGroup = Thread.currentThread().getThreadGroup();
        while (systemGroup.getParent() != null) {
            systemGroup = systemGroup.getParent();
        }
        if (SystemUtils.isJavaVersionAtLeast(1.5f)) {
            ThreadTracking.prepare15UncaughtExceptionHandler();
        }
        rootThreadGroup = new PhexThreadGroup("PhexRoot");
        threadPoolGroup = new PhexThreadGroup("PhexThreadPool");
    }

    private static void prepare15UncaughtExceptionHandler() {
        try {
            InvocationHandler invocationHandler = new InvocationHandler(){

                public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                    if (method != null && "uncaughtException".equals(method.getName())) {
                        Thread thread = (Thread)objectArray[0];
                        Throwable throwable = (Throwable)objectArray[1];
                        NLogger.error("GLOBAL", (Object)("Uncaught exception: " + throwable.getMessage() + " in Thread: " + thread.getName()), throwable);
                    }
                    return null;
                }
            };
            Object object = Proxy.newProxyInstance(ClassLoader.getSystemClassLoader(), new Class[]{Class.forName("java.lang.Thread$UncaughtExceptionHandler")}, invocationHandler);
            Method method = Thread.class.getDeclaredMethod("setDefaultUncaughtExceptionHandler", Class.forName("java.lang.Thread$UncaughtExceptionHandler"));
            method.invoke(null, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            NLogger.error(ThreadTracking.class, (Object)illegalArgumentException, (Throwable)illegalArgumentException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NLogger.error(ThreadTracking.class, (Object)classNotFoundException, (Throwable)classNotFoundException);
        }
        catch (SecurityException securityException) {
            NLogger.error(ThreadTracking.class, (Object)securityException, (Throwable)securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            NLogger.error(ThreadTracking.class, (Object)noSuchMethodException, (Throwable)noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            NLogger.error(ThreadTracking.class, (Object)illegalAccessException, (Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            NLogger.error(ThreadTracking.class, (Object)invocationTargetException, (Throwable)invocationTargetException);
        }
    }

    private static class PhexThreadGroup
    extends ThreadGroup {
        public PhexThreadGroup(String string) {
            super(systemGroup, string);
        }

        public void uncaughtException(Thread thread, Throwable throwable) {
            super.uncaughtException(thread, throwable);
            NLogger.error("GLOBAL", (Object)("Uncaught exception: " + throwable.getMessage() + " in Thread: " + thread.getName()), throwable);
        }
    }
}

