/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

import java.util.Vector;
import phex.common.ThreadTracking;
import phex.utils.NLogger;

public class RunnerQueueWorker {
    private boolean isInterrupted = false;
    private boolean isPaused = false;
    private Vector queue = new Vector();
    private Thread runnerThread;

    public synchronized void setPause(boolean bl) {
        this.isPaused = bl;
        this.notify();
    }

    public synchronized void stopAndClear() {
        this.queue.clear();
        if (this.runnerThread != null) {
            this.runnerThread.interrupt();
            this.isInterrupted = true;
        }
    }

    public synchronized void add(Runnable runnable) {
        this.queue.add(runnable);
        this.notify();
        if (this.runnerThread == null) {
            this.createRunner();
        }
    }

    private synchronized void createRunner() {
        this.isInterrupted = false;
        this.runnerThread = new Thread(ThreadTracking.rootThreadGroup, new QueueWorker());
        this.runnerThread.setPriority(5);
        this.runnerThread.setDaemon(true);
        this.runnerThread.start();
    }

    private class QueueWorker
    implements Runnable {
        private QueueWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                while (true) {
                    Runnable runnable = (Runnable)RunnerQueueWorker.this.queue.remove(0);
                    try {
                        runnable.run();
                    }
                    catch (Throwable throwable) {
                        NLogger.error("GLOBAL", (Object)throwable, throwable);
                    }
                    RunnerQueueWorker runnerQueueWorker = RunnerQueueWorker.this;
                    synchronized (runnerQueueWorker) {
                        if (!(RunnerQueueWorker.this.queue.isEmpty() || RunnerQueueWorker.this.isInterrupted || RunnerQueueWorker.this.isPaused)) {
                            continue;
                        }
                        try {
                            while (RunnerQueueWorker.this.isPaused) {
                                RunnerQueueWorker.this.wait(5000L);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (RunnerQueueWorker.this.queue.isEmpty() || RunnerQueueWorker.this.isInterrupted) break;
                    }
                }
                {
                    RunnerQueueWorker.this.runnerThread = null;
                }
            }
            catch (Throwable throwable) {
                RunnerQueueWorker.this.runnerThread = null;
                NLogger.error("GLOBAL", (Object)throwable, throwable);
            }
            if (!RunnerQueueWorker.this.queue.isEmpty()) {
                RunnerQueueWorker.this.createRunner();
            }
        }
    }
}

