/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import phex.host.HostManager;
import phex.msg.PongMsg;
import phex.utils.PriorityQueue;

public class PongCache {
    private static final PongCache singleton = new PongCache();
    private static final int PONGS_PER_HOP = 1;
    private static final int MAX_HOPS = 6;
    private static final int EXPIRE_TIME_MILLIS = 60000;
    private static PriorityQueue pongQueue;

    private PongCache() {
        int[] nArray = new int[6];
        Arrays.fill(nArray, 1);
        pongQueue = new PriorityQueue(nArray);
    }

    public static PongCache getInstance() {
        return Holder.instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getPongs() {
        PriorityQueue priorityQueue = pongQueue;
        synchronized (priorityQueue) {
            LinkedList<PongMsg> linkedList = new LinkedList<PongMsg>();
            LinkedList<PongMsg> linkedList2 = null;
            long l = System.currentTimeMillis();
            Iterator iterator = pongQueue.iterator();
            while (iterator.hasNext()) {
                PongMsg pongMsg = (PongMsg)iterator.next();
                if (l - pongMsg.getCreationTime() > 60000L) {
                    if (linkedList2 == null) {
                        linkedList2 = new LinkedList<PongMsg>();
                    }
                    linkedList2.add(pongMsg);
                    continue;
                }
                linkedList.add(pongMsg);
            }
            this.removePongs(linkedList2);
            return linkedList;
        }
    }

    private void removePongs(List list) {
        if (list == null) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            PongMsg pongMsg = (PongMsg)iterator.next();
            pongQueue.removeFromAll(pongMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPong(PongMsg pongMsg) {
        if (!pongMsg.isUltrapeerMarked()) {
            return;
        }
        if (!HostManager.getInstance().isUltrapeer()) {
            return;
        }
        int n = pongMsg.getHeader().getHopsTaken() - 1;
        if (n >= 6) {
            return;
        }
        PriorityQueue priorityQueue = pongQueue;
        synchronized (priorityQueue) {
            pongQueue.addToHead(pongMsg, n);
        }
    }

    private static class Holder {
        protected static final PongCache instance = new PongCache();

        private Holder() {
        }
    }
}

