/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import phex.chat.ChatManager;
import phex.common.Ip2CountryManager;
import phex.common.Manager;
import phex.common.bandwidth.BandwidthManager;
import phex.connection.NetworkManager;
import phex.download.swarming.SwarmingManager;
import phex.gwebcache.GWebCacheManager;
import phex.host.HostManager;
import phex.msg.MsgManager;
import phex.query.QueryManager;
import phex.security.PhexSecurityManager;
import phex.share.ShareManager;
import phex.statistic.StatisticsManager;
import phex.udp.UdpConnectionManager;
import phex.udp.hostcache.UdpHostCacheManager;
import phex.upload.UploadManager;
import phex.utils.NLogger;

public class ManagerController {
    private static final List MANAGER_LIST;

    public static void initializeManagers() {
        Iterator iterator = MANAGER_LIST.iterator();
        while (iterator.hasNext()) {
            Manager manager = (Manager)iterator.next();
            long l = System.currentTimeMillis();
            NLogger.debug("GLOBAL", (Object)("Initializing " + manager.getClass().getName()));
            boolean bl = manager.initialize();
            if (!bl) {
                NLogger.error("GLOBAL", "Failed to initialize " + manager.getClass().getName());
                throw new RuntimeException("Failed to initialize " + manager.getClass().getName());
            }
            long l2 = System.currentTimeMillis();
            NLogger.debug("GLOBAL", (Object)("Initialization time: " + (l2 - l) + " - " + manager.getClass().getName()));
        }
        ManagerController.postInitializeManagers();
    }

    private static void postInitializeManagers() {
        Iterator iterator = MANAGER_LIST.iterator();
        while (iterator.hasNext()) {
            Manager manager = (Manager)iterator.next();
            long l = System.currentTimeMillis();
            NLogger.debug("GLOBAL", (Object)("On post initialization " + manager.getClass().getName()));
            boolean bl = manager.onPostInitialization();
            if (!bl) {
                NLogger.error("GLOBAL", "Failed to initialize " + manager.getClass().getName());
                throw new RuntimeException("Failed to initialize " + manager.getClass().getName());
            }
            long l2 = System.currentTimeMillis();
            NLogger.debug("GLOBAL", (Object)("Post-Initialization time: " + (l2 - l) + " - " + manager.getClass().getName()));
        }
    }

    public static void startupCompletedNotify() {
        Iterator iterator = MANAGER_LIST.iterator();
        while (iterator.hasNext()) {
            Manager manager = (Manager)iterator.next();
            long l = System.currentTimeMillis();
            NLogger.debug("GLOBAL", (Object)("StartupCompletedNotify " + manager.getClass().getName()));
            manager.startupCompletedNotify();
            long l2 = System.currentTimeMillis();
            NLogger.debug("GLOBAL", (Object)("StartupCompletedNotify time: " + (l2 - l) + " - " + manager.getClass().getName()));
        }
    }

    public static void shutdownManagers() {
        Iterator iterator = MANAGER_LIST.iterator();
        while (iterator.hasNext()) {
            try {
                Manager manager = (Manager)iterator.next();
                long l = System.currentTimeMillis();
                NLogger.debug("GLOBAL", (Object)("Shutdown " + manager.getClass().getName()));
                manager.shutdown();
                long l2 = System.currentTimeMillis();
                NLogger.debug("GLOBAL", (Object)("Shutdown time: " + (l2 - l) + " - " + manager.getClass().getName()));
            }
            catch (Exception exception) {
                NLogger.error("GLOBAL", (Object)exception, (Throwable)exception);
            }
        }
    }

    static {
        ArrayList<Manager> arrayList = new ArrayList<Manager>();
        arrayList.add(SwarmingManager.getInstance());
        arrayList.add(NetworkManager.getInstance());
        arrayList.add(UdpConnectionManager.getInstance());
        arrayList.add(UploadManager.getInstance());
        arrayList.add(ShareManager.getInstance());
        arrayList.add(QueryManager.getInstance());
        arrayList.add(ChatManager.getInstance());
        arrayList.add(HostManager.getInstance());
        arrayList.add(PhexSecurityManager.getInstance());
        arrayList.add(MsgManager.getInstance());
        arrayList.add(StatisticsManager.getInstance());
        arrayList.add(BandwidthManager.getInstance());
        arrayList.add(GWebCacheManager.getInstance());
        arrayList.add(Ip2CountryManager.getInstance());
        arrayList.add(UdpHostCacheManager.getInstance());
        MANAGER_LIST = Collections.unmodifiableList(arrayList);
    }
}

