/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.list.UnmodifiableList;
import phex.common.AbstractManager;
import phex.common.ThreadPool;
import phex.common.address.AddressUtils;
import phex.common.address.IpAddress;
import phex.utils.IOUtil;
import phex.utils.Logger;
import phex.utils.NLogger;

public class Ip2CountryManager
extends AbstractManager {
    private boolean isLoaded = false;
    private List ipCountryRangeList = new ArrayList();

    private Ip2CountryManager() {
    }

    public static Ip2CountryManager getInstance() {
        return Holder.manager;
    }

    public boolean initialize() {
        return true;
    }

    public boolean onPostInitialization() {
        return true;
    }

    public void startupCompletedNotify() {
        Runnable runnable = new Runnable(){

            public void run() {
                Ip2CountryManager.this.loadIp2CountryDB();
            }
        };
        ThreadPool.getInstance().addJob(runnable, "IP2CountryLoader");
    }

    public void shutdown() {
    }

    public String getCountryCode(IpAddress ipAddress) {
        if (!this.isLoaded) {
            return null;
        }
        IpCountryRange ipCountryRange = this.binarySearch(ipAddress.getHostIP());
        if (ipCountryRange == null) {
            return "";
        }
        return ipCountryRange.countryCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadIp2CountryDB() {
        InputStream inputStream = ClassLoader.getSystemResourceAsStream("phex/resources/ip2country.csv");
        if (inputStream == null) {
            Logger.logMessage(Logger.FINE, (short)16, "Default GWebCache file not found.");
            return;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        ArrayList<IpCountryRange> arrayList = new ArrayList<IpCountryRange>(5000);
        try {
            String string = bufferedReader.readLine();
            while (string != null) {
                IpCountryRange ipCountryRange = new IpCountryRange(string);
                arrayList.add(ipCountryRange);
                string = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            NLogger.error("GLOBAL", (Object)iOException, (Throwable)iOException);
        }
        finally {
            IOUtil.closeQuietly(bufferedReader);
        }
        arrayList.trimToSize();
        Collections.sort(arrayList);
        this.ipCountryRangeList = UnmodifiableList.decorate(arrayList);
        this.isLoaded = true;
    }

    private IpCountryRange binarySearch(byte[] byArray) {
        int n = 0;
        int n2 = this.ipCountryRangeList.size() - 1;
        while (n <= n2) {
            int n3 = n + n2 >> 1;
            IpCountryRange ipCountryRange = (IpCountryRange)this.ipCountryRangeList.get(n3);
            int n4 = ipCountryRange.compareHostAddress(byArray);
            if (n4 < 0) {
                n = n3 + 1;
                continue;
            }
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            return ipCountryRange;
        }
        return null;
    }

    private class IpCountryRange
    implements Comparable {
        byte[] from;
        byte[] to;
        String countryCode;

        public IpCountryRange(String string) {
            int n = 0;
            int n2 = string.indexOf(44, n);
            this.from = AddressUtils.parseIntIP(string.substring(n, n2));
            n = n2 + 1;
            n2 = string.indexOf(44, n);
            this.to = AddressUtils.parseIntIP(string.substring(n, n2));
            n = n2 + 1;
            this.countryCode = string.substring(n);
        }

        public int compareHostAddress(byte[] byArray) {
            long l;
            long l2 = IOUtil.unsignedInt2Long(IOUtil.deserializeInt(byArray, 0));
            long l3 = l2 - (l = IOUtil.unsignedInt2Long(IOUtil.deserializeInt(this.from, 0)));
            if (l3 == 0L) {
                return 0;
            }
            if (l3 < 0L) {
                return 1;
            }
            long l4 = IOUtil.unsignedInt2Long(IOUtil.deserializeInt(this.to, 0));
            l3 = l2 - l4;
            if (l3 == 0L || l3 < 0L) {
                return 0;
            }
            return -1;
        }

        public int compareTo(Object object) {
            long l;
            if (object == this) {
                return 0;
            }
            IpCountryRange ipCountryRange = (IpCountryRange)object;
            byte[] byArray = this.from;
            byte[] byArray2 = ipCountryRange.from;
            long l2 = IOUtil.unsignedInt2Long(IOUtil.deserializeInt(byArray, 0));
            if (l2 < (l = IOUtil.unsignedInt2Long(IOUtil.deserializeInt(byArray2, 0)))) {
                return -1;
            }
            return 1;
        }
    }

    private static class Holder {
        protected static final Ip2CountryManager manager = new Ip2CountryManager();

        private Holder() {
        }
    }
}

