/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

import java.util.HashSet;
import java.util.Set;
import java.util.TimerTask;
import phex.common.Environment;
import phex.common.address.DefaultDestAddress;
import phex.msg.PongMsg;
import phex.utils.NLogger;

public class HorizonTracker {
    private static final int MAX_PONG_COUNT = 10000;
    private static HorizonTracker instance = new HorizonTracker();
    private boolean useLastCountValues;
    private Set trackedAddresses;
    private int currentHostCount;
    private long currentFileCount;
    private long currentFileSize;
    private int lastHostCount;
    private long lastFileCount;
    private long lastFileSize;

    private HorizonTracker() {
        Environment.getInstance().scheduleTimerTask(new TrackerRefreshTimer(), 900000L, 900000L);
        this.useLastCountValues = false;
        this.trackedAddresses = new HashSet();
    }

    public static HorizonTracker getInstance() {
        return instance;
    }

    public long getTotalFileCount() {
        return this.useLastCountValues ? this.lastFileCount : this.currentFileCount;
    }

    public long getTotalFileSize() {
        return this.useLastCountValues ? this.lastFileSize : this.currentFileSize;
    }

    public int getTotalHostCount() {
        return this.useLastCountValues ? this.lastHostCount : this.currentHostCount;
    }

    public synchronized void trackPong(PongMsg pongMsg) {
        if (this.trackedAddresses.size() > 10000) {
            return;
        }
        DefaultDestAddress defaultDestAddress = new DefaultDestAddress(pongMsg.getIP(), pongMsg.getPort());
        boolean bl = this.trackedAddresses.add(defaultDestAddress);
        if (bl) {
            this.currentFileCount += pongMsg.getFileCount();
            this.currentFileSize += pongMsg.getFileSizeInKB();
            ++this.currentHostCount;
        }
    }

    private synchronized void refreshTrackerStats() {
        this.lastHostCount = this.currentHostCount;
        this.lastFileCount = this.currentFileCount;
        this.lastFileSize = this.currentFileSize;
        this.useLastCountValues = true;
        this.currentFileCount = 0L;
        this.currentFileSize = 0L;
        this.currentHostCount = 0;
        this.trackedAddresses.clear();
    }

    private class TrackerRefreshTimer
    extends TimerTask {
        private static final long TIMER_PERIOD = 900000L;

        private TrackerRefreshTimer() {
        }

        public void run() {
            try {
                HorizonTracker.this.refreshTrackerStats();
            }
            catch (Throwable throwable) {
                NLogger.error("GLOBAL", (Object)throwable, throwable);
            }
        }
    }
}

