/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

import java.util.Date;

public class ExpiryDate
extends Date {
    public static final long EXPIRES_NEVER = Long.MAX_VALUE;
    public static final long EXPIRES_END_OF_SESSION = -1L;
    public static final ExpiryDate NEVER_EXPIRY_DATE = new ExpiryDate(Long.MAX_VALUE);
    public static final ExpiryDate SESSION_EXPIRY_DATE = new ExpiryDate(-1L);

    public static ExpiryDate getExpiryDate(long l) {
        if (l == Long.MAX_VALUE) {
            return NEVER_EXPIRY_DATE;
        }
        if (l == -1L) {
            return SESSION_EXPIRY_DATE;
        }
        return new ExpiryDate(l);
    }

    private ExpiryDate(long l) {
        super(l);
    }

    public boolean isExpiringEndOfSession() {
        return this.getTime() == -1L;
    }

    public boolean isExpiringNever() {
        return this.getTime() == Long.MAX_VALUE;
    }

    public boolean isExpired() {
        if (this.isExpiringEndOfSession() || this.isExpiringNever()) {
            return false;
        }
        return this.getTime() < System.currentTimeMillis();
    }
}

