/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.lang.SystemUtils;
import phex.event.UserMessageListener;
import phex.utils.NLogger;
import phex.utils.VersionUtils;

public class Environment {
    private Properties properties;
    private File configurationRoot;
    private UserMessageListener userMessageListener;
    private Timer timerService;
    private String javaVersion;

    private Environment() {
        try {
            this.properties = new Properties();
            this.properties.load(Environment.class.getResourceAsStream("/phex/resources/version.properties"));
        }
        catch (IOException iOException) {
            NLogger.error("STARTUP", (Object)iOException, (Throwable)iOException);
            throw new RuntimeException();
        }
        this.initializeJavaVersion();
        this.timerService = new Timer(true);
    }

    public static Environment getInstance() {
        return Holder.environment;
    }

    public void setPhexConfigRoot(File file) throws IOException {
        boolean bl;
        if (file == null) {
            StringBuffer stringBuffer = new StringBuffer(20);
            stringBuffer.append(System.getProperty("user.home"));
            stringBuffer.append(File.separator);
            if (File.separatorChar == '/') {
                stringBuffer.append('.');
            }
            stringBuffer.append("phex");
            file = new File(stringBuffer.toString());
        }
        if (!file.isDirectory() && !(bl = file.mkdirs())) {
            throw new IOException("Cant create directory: " + file.getAbsolutePath());
        }
        this.configurationRoot = file;
    }

    public File getPhexConfigFile(String string) {
        if (this.configurationRoot == null) {
            try {
                this.setPhexConfigRoot(null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new File(this.configurationRoot, string);
    }

    public String getProperty(String string) {
        return this.properties.getProperty(string);
    }

    public String getProperty(String string, String string2) {
        return this.properties.getProperty(string, string2);
    }

    public static String getPhexVendor() {
        return "Phex " + VersionUtils.getFullProgramVersion();
    }

    public void scheduleTimerTask(TimerTask timerTask, long l, long l2) {
        this.timerService.schedule(timerTask, l, l2);
    }

    public void scheduleTimerTask(TimerTask timerTask, long l) {
        this.timerService.schedule(timerTask, l);
    }

    public boolean isUltrapeerOS() {
        return !SystemUtils.IS_OS_WINDOWS || SystemUtils.IS_OS_WINDOWS_2000 || SystemUtils.IS_OS_WINDOWS_XP;
    }

    private void initializeJavaVersion() {
        this.javaVersion = System.getProperty("java.version");
    }

    public boolean isJava14orLater() {
        return !this.javaVersion.startsWith("1.3") && !this.javaVersion.startsWith("1.2") && !this.javaVersion.startsWith("1.1") && !this.javaVersion.startsWith("1.0");
    }

    public void setUserMessageListener(UserMessageListener userMessageListener) {
        this.userMessageListener = userMessageListener;
    }

    public void fireDisplayUserMessage(String string) {
        if (this.userMessageListener != null) {
            this.userMessageListener.displayUserMessage(string, null);
        }
    }

    public void fireDisplayUserMessage(String string, String[] stringArray) {
        if (this.userMessageListener != null) {
            this.userMessageListener.displayUserMessage(string, stringArray);
        }
    }

    private static class Holder {
        protected static final Environment environment = new Environment();

        private Holder() {
        }
    }
}

