/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import phex.common.URN;
import phex.common.address.AddressUtils;
import phex.common.address.DefaultDestAddress;
import phex.common.address.DestAddress;
import phex.common.address.MalformedDestAddressException;
import phex.security.PhexSecurityManager;
import phex.utils.Logger;
import phex.utils.NLogger;

public class AlternateLocation {
    public static final Short DEFAULT_HOST_RATING = new Short(6);
    private DestAddress hostAddress;
    private URN urn;

    public AlternateLocation(DestAddress destAddress, URN uRN) {
        this.hostAddress = destAddress;
        this.urn = uRN;
    }

    public DestAddress getHostAddress() {
        return this.hostAddress;
    }

    public URN getURN() {
        return this.urn;
    }

    public String getHTTPString() {
        StringBuffer stringBuffer = new StringBuffer(this.hostAddress.getHostName());
        int n = this.hostAddress.getPort();
        if (n != 6346) {
            stringBuffer.append(':');
            stringBuffer.append(n);
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof AlternateLocation)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        AlternateLocation alternateLocation = (AlternateLocation)object;
        return this.hostAddress.equals(alternateLocation.hostAddress) && this.urn.equals(alternateLocation.urn);
    }

    public int hashCode() {
        int n = 7;
        n = 31 * n + (this.hostAddress != null ? ((Object)this.hostAddress).hashCode() : 0);
        n = 31 * n + (this.urn != null ? this.urn.hashCode() : 0);
        return n;
    }

    public static AlternateLocation parseCompactIpAltLoc(String string, URN uRN) {
        DestAddress destAddress;
        try {
            destAddress = AddressUtils.parseAndValidateAddress(string, false);
        }
        catch (MalformedDestAddressException malformedDestAddressException) {
            NLogger.debug(AlternateLocation.class, (Object)("Malformed alt-location URL: " + malformedDestAddressException.getMessage()));
            return null;
        }
        AlternateLocation alternateLocation = new AlternateLocation(destAddress, uRN);
        return alternateLocation;
    }

    public static AlternateLocation parseUriResAltLoc(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r\f\"");
        String string2 = null;
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            stringTokenizer.nextToken();
        }
        try {
            URL uRL = new URL(string2);
            String string3 = uRL.getProtocol();
            if (!"http".equals(string3)) {
                Logger.logMessage(Logger.FINE, (short)2, "Invalid alt-location URL (Not a http URL): " + string2);
                return null;
            }
            String string4 = uRL.getHost();
            int n = uRL.getPort();
            if (n == -1) {
                Logger.logMessage(Logger.FINE, (short)2, "Invalid legacy alt-loc without specified port.");
                return null;
            }
            DefaultDestAddress defaultDestAddress = new DefaultDestAddress(string4, n);
            if (!defaultDestAddress.isValidAddress()) {
                Logger.logMessage(Logger.FINE, (short)2, "Invalid alt-location URL (Invalid address): " + string2);
                return null;
            }
            byte by = PhexSecurityManager.getInstance().controlHostAddressAccess(defaultDestAddress);
            switch (by) {
                case 2: 
                case 3: {
                    Logger.logMessage(Logger.FINE, (short)2, "Alt-Location host denied: " + string2);
                    return null;
                }
            }
            if (!defaultDestAddress.getIpAddress().isValidIP()) {
                Logger.logMessage(Logger.FINE, (short)2, "Invalid alt-location URL (Invalid IP used): " + string2);
                return null;
            }
            if (defaultDestAddress.getIpAddress().isSiteLocalIP()) {
                Logger.logMessage(Logger.FINE, (short)2, "Invalid alt-location URL (Private IP used): " + string2);
                return null;
            }
            URN uRN = URN.parseURNFromUriRes(uRL.getFile());
            if (uRN == null) {
                Logger.logMessage(Logger.FINE, (short)2, "Alt-location path without URN: " + string);
                return null;
            }
            AlternateLocation alternateLocation = new AlternateLocation(defaultDestAddress, uRN);
            return alternateLocation;
        }
        catch (MalformedURLException malformedURLException) {
            Logger.logMessage(Logger.FINE, (short)2, "Invalid alt-location URL (Malformed: " + malformedURLException.getMessage() + " ): " + string2);
            return null;
        }
    }
}

