/*
 * Decompiled with CFR 0.152.
 */
package phex.chat;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import phex.chat.ChatEngine;
import phex.common.AbstractManager;
import phex.common.ServiceManager;
import phex.common.address.DestAddress;
import phex.event.AsynchronousDispatcher;
import phex.event.ChatListener;
import phex.net.presentation.SocketFacade;
import phex.utils.GnutellaInputStream;
import phex.utils.IOUtil;
import phex.utils.NLogger;

public class ChatManager
extends AbstractManager {
    private Set openIpAddressSet;
    private ArrayList listenerList = new ArrayList(1);

    private ChatManager() {
    }

    public static ChatManager getInstance() {
        return Holder.manager;
    }

    public boolean initialize() {
        return true;
    }

    public boolean onPostInitialization() {
        return true;
    }

    public void startupCompletedNotify() {
    }

    public void shutdown() {
    }

    public void openChat(DestAddress destAddress) {
        ChatEngine chatEngine = new ChatEngine(destAddress);
        chatEngine.startChat();
        this.fireChatConnectionOpened(chatEngine);
    }

    public void chatClosed(ChatEngine chatEngine) {
        this.openIpAddressSet.remove(chatEngine.getHostAddress().getIpAddress());
        this.fireChatConnectionFailed(chatEngine);
    }

    public void acceptChat(SocketFacade socketFacade, GnutellaInputStream gnutellaInputStream, DestAddress destAddress) {
        if (!ServiceManager.sCfg.isChatEnabled) {
            IOUtil.closeQuietly(socketFacade);
            return;
        }
        if (this.openIpAddressSet.contains(destAddress.getIpAddress())) {
            IOUtil.closeQuietly(socketFacade);
            return;
        }
        try {
            ChatEngine chatEngine = new ChatEngine(socketFacade, gnutellaInputStream, destAddress);
            this.openIpAddressSet.add(destAddress.getIpAddress());
            chatEngine.startChat();
            this.fireChatConnectionOpened(chatEngine);
        }
        catch (IOException iOException) {
            NLogger.debug(ChatManager.class, (Object)iOException, (Throwable)iOException);
            IOUtil.closeQuietly(socketFacade);
            return;
        }
    }

    public void addChatListener(ChatListener chatListener) {
        this.listenerList.add(chatListener);
    }

    public void removeChatListener(ChatListener chatListener) {
        this.listenerList.remove(chatListener);
    }

    public void fireChatConnectionOpened(final ChatEngine chatEngine) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = ChatManager.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    ChatListener chatListener = (ChatListener)objectArray[i];
                    chatListener.chatConnectionOpened(chatEngine);
                }
            }
        });
    }

    public void fireChatConnectionFailed(final ChatEngine chatEngine) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = ChatManager.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    ChatListener chatListener = (ChatListener)objectArray[i];
                    chatListener.chatConnectionFailed(chatEngine);
                }
            }
        });
    }

    public void fireChatMessageReceived(final ChatEngine chatEngine, final String string) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = ChatManager.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    ChatListener chatListener = (ChatListener)objectArray[i];
                    chatListener.chatMessageReceived(chatEngine, string);
                }
            }
        });
    }

    private static class Holder {
        protected static final ChatManager manager = new ChatManager();

        private Holder() {
        }
    }
}

