/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.decorator.ComponentAdapter;

public class JXTree
extends JTree {
    private static final Logger LOG = Logger.getLogger(JXTree.class.getName());
    private Method conversionMethod = null;
    private static final Class[] methodSignature = new Class[]{Object.class};
    private static final Object[] methodArgs = new Object[]{null};
    private ChangeListener highlighterChangeListener;
    private DelegatingRenderer delegatingRenderer;
    private boolean overwriteIcons;
    private final ComponentAdapter dataAdapter = new TreeAdapter(this);

    public JXTree() {
    }

    public JXTree(Object[] objectArray) {
        super(objectArray);
    }

    public JXTree(Vector vector) {
        super(vector);
    }

    public JXTree(Hashtable hashtable) {
        super(hashtable);
    }

    public JXTree(TreeNode treeNode) {
        super(treeNode, false);
    }

    public JXTree(TreeNode treeNode, boolean bl) {
        super(treeNode, bl);
    }

    public JXTree(TreeModel treeModel) {
        super(treeModel);
        this.conversionMethod = this.getValueConversionMethod(treeModel);
    }

    public void setModel(TreeModel treeModel) {
        this.conversionMethod = this.getValueConversionMethod(treeModel);
        super.setModel(treeModel);
    }

    private Method getValueConversionMethod(TreeModel treeModel) {
        try {
            return treeModel == null ? null : treeModel.getClass().getMethod("convertValueToText", methodSignature);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LOG.finer("ex " + noSuchMethodException);
            LOG.finer("no conversionMethod in " + treeModel.getClass());
            return null;
        }
    }

    public String convertValueToText(Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        if (object != null) {
            if (this.conversionMethod == null) {
                return object.toString();
            }
            try {
                JXTree.methodArgs[0] = object;
                return (String)this.conversionMethod.invoke((Object)this.getModel(), methodArgs);
            }
            catch (Exception exception) {
                LOG.finer("ex " + exception);
                LOG.finer("can't invoke " + this.conversionMethod);
            }
        }
        return "";
    }

    public void collapseAll() {
        for (int i = this.getRowCount() - 1; i >= 0; --i) {
            this.collapseRow(i);
        }
    }

    public void expandAll() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.expandRow(i);
        }
    }

    private ChangeListener getHighlighterChangeListener() {
        if (this.highlighterChangeListener == null) {
            this.highlighterChangeListener = new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    JXTree.this.repaint();
                }
            };
        }
        return this.highlighterChangeListener;
    }

    private DelegatingRenderer getDelegatingRenderer() {
        if (this.delegatingRenderer == null) {
            this.delegatingRenderer = new DelegatingRenderer();
            this.delegatingRenderer.setDelegateRenderer(super.getCellRenderer());
        }
        return this.delegatingRenderer;
    }

    public TreeCellRenderer getCellRenderer() {
        return this.getDelegatingRenderer();
    }

    public void setCellRenderer(TreeCellRenderer treeCellRenderer) {
        this.getDelegatingRenderer().setDelegateRenderer(treeCellRenderer);
        super.setCellRenderer(this.delegatingRenderer);
    }

    public void setExpandedIcon(Icon icon) {
        if (this.getUI() instanceof BasicTreeUI) {
            ((BasicTreeUI)this.getUI()).setExpandedIcon(icon);
        }
    }

    public void setCollapsedIcon(Icon icon) {
        if (this.getUI() instanceof BasicTreeUI) {
            ((BasicTreeUI)this.getUI()).setCollapsedIcon(icon);
        }
    }

    public void setLeafIcon(Icon icon) {
        this.getDelegatingRenderer().setLeafIcon(icon);
    }

    public void setOpenIcon(Icon icon) {
        this.getDelegatingRenderer().setOpenIcon(icon);
    }

    public void setClosedIcon(Icon icon) {
        this.getDelegatingRenderer().setClosedIcon(icon);
    }

    public void setOverwriteRendererIcons(boolean bl) {
        if (this.overwriteIcons == bl) {
            return;
        }
        boolean bl2 = this.overwriteIcons;
        this.overwriteIcons = bl;
        this.firePropertyChange("overwriteRendererIcons", bl2, bl);
    }

    public boolean isOverwriteRendererIcons() {
        return this.overwriteIcons;
    }

    protected ComponentAdapter getComponentAdapter() {
        return this.dataAdapter;
    }

    protected static class TreeAdapter
    extends ComponentAdapter {
        private final JXTree tree;

        public TreeAdapter(JXTree jXTree) {
            super(jXTree);
            this.tree = jXTree;
        }

        public JXTree getTree() {
            return this.tree;
        }

        public boolean hasFocus() {
            return this.tree.isFocusOwner() && this.tree.getLeadSelectionRow() == this.row;
        }

        public Object getValueAt(int n, int n2) {
            TreePath treePath = this.tree.getPathForRow(n);
            return treePath.getLastPathComponent();
        }

        public Object getFilteredValueAt(int n, int n2) {
            return this.getValueAt(n, n2);
        }

        public boolean isSelected() {
            return this.tree.isRowSelected(this.row);
        }

        public boolean isExpanded() {
            return this.tree.isExpanded(this.row);
        }

        public boolean isLeaf() {
            return this.tree.getModel().isLeaf(this.getValue());
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public void setValueAt(Object object, int n, int n2) {
        }

        public String getColumnName(int n) {
            return "Column_" + n;
        }

        public String getColumnIdentifier(int n) {
            return null;
        }
    }

    public class DelegatingRenderer
    implements TreeCellRenderer {
        private Icon closedIcon = null;
        private Icon openIcon = null;
        private Icon leafIcon = null;
        private TreeCellRenderer delegate;

        public DelegatingRenderer() {
            this.initIcons(new DefaultTreeCellRenderer());
        }

        private void initIcons(DefaultTreeCellRenderer defaultTreeCellRenderer) {
            this.closedIcon = defaultTreeCellRenderer.getDefaultClosedIcon();
            this.openIcon = defaultTreeCellRenderer.getDefaultOpenIcon();
            this.leafIcon = defaultTreeCellRenderer.getDefaultLeafIcon();
        }

        public void setDelegateRenderer(TreeCellRenderer treeCellRenderer) {
            if (treeCellRenderer == null) {
                treeCellRenderer = new DefaultTreeCellRenderer();
            }
            this.delegate = treeCellRenderer;
            this.updateIcons();
        }

        private void updateIcons() {
            if (!JXTree.this.isOverwriteRendererIcons()) {
                return;
            }
            this.setClosedIcon(this.closedIcon);
            this.setOpenIcon(this.openIcon);
            this.setLeafIcon(this.leafIcon);
        }

        public void setClosedIcon(Icon icon) {
            if (this.delegate instanceof DefaultTreeCellRenderer) {
                ((DefaultTreeCellRenderer)this.delegate).setClosedIcon(icon);
            }
            this.closedIcon = icon;
        }

        public void setOpenIcon(Icon icon) {
            if (this.delegate instanceof DefaultTreeCellRenderer) {
                ((DefaultTreeCellRenderer)this.delegate).setOpenIcon(icon);
            }
            this.openIcon = icon;
        }

        public void setLeafIcon(Icon icon) {
            if (this.delegate instanceof DefaultTreeCellRenderer) {
                ((DefaultTreeCellRenderer)this.delegate).setLeafIcon(icon);
            }
            this.leafIcon = icon;
        }

        public TreeCellRenderer getDelegateRenderer() {
            return this.delegate;
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Component component = this.delegate.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            return component;
        }
    }
}

