/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.iterators;

import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections.ResettableListIterator;
import org.apache.commons.collections.iterators.ObjectArrayIterator;

public class ObjectArrayListIterator
extends ObjectArrayIterator
implements ListIterator,
ResettableListIterator {
    protected int lastItemIndex = -1;

    public ObjectArrayListIterator() {
    }

    public ObjectArrayListIterator(Object[] objectArray) {
        super(objectArray);
    }

    public ObjectArrayListIterator(Object[] objectArray, int n) {
        super(objectArray, n);
    }

    public ObjectArrayListIterator(Object[] objectArray, int n, int n2) {
        super(objectArray, n, n2);
    }

    public boolean hasPrevious() {
        return this.index > this.startIndex;
    }

    public Object previous() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        this.lastItemIndex = --this.index;
        return this.array[this.index];
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.lastItemIndex = this.index;
        return this.array[this.index++];
    }

    public int nextIndex() {
        return this.index - this.startIndex;
    }

    public int previousIndex() {
        return this.index - this.startIndex - 1;
    }

    public void add(Object object) {
        throw new UnsupportedOperationException("add() method is not supported");
    }

    public void set(Object object) {
        if (this.lastItemIndex == -1) {
            throw new IllegalStateException("must call next() or previous() before a call to set()");
        }
        this.array[this.lastItemIndex] = object;
    }

    public void reset() {
        super.reset();
        this.lastItemIndex = -1;
    }
}

