/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.functors;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.functors.ConstantTransformer;
import org.apache.commons.collections.functors.FunctorUtils;

public class SwitchTransformer
implements Transformer,
Serializable {
    private final Predicate[] iPredicates;
    private final Transformer[] iTransformers;
    private final Transformer iDefault;

    public static Transformer getInstance(Predicate[] predicateArray, Transformer[] transformerArray, Transformer transformer) {
        FunctorUtils.validate(predicateArray);
        FunctorUtils.validate(transformerArray);
        if (predicateArray.length != transformerArray.length) {
            throw new IllegalArgumentException("The predicate and transformer arrays must be the same size");
        }
        if (predicateArray.length == 0) {
            return transformer == null ? ConstantTransformer.NULL_INSTANCE : transformer;
        }
        predicateArray = FunctorUtils.copy(predicateArray);
        transformerArray = FunctorUtils.copy(transformerArray);
        return new SwitchTransformer(predicateArray, transformerArray, transformer);
    }

    public static Transformer getInstance(Map map) {
        Transformer[] transformerArray = null;
        Predicate[] predicateArray = null;
        if (map == null) {
            throw new IllegalArgumentException("The predicate and transformer map must not be null");
        }
        if (map.size() == 0) {
            return ConstantTransformer.NULL_INSTANCE;
        }
        Transformer transformer = (Transformer)map.remove(null);
        int n = map.size();
        if (n == 0) {
            return transformer == null ? ConstantTransformer.NULL_INSTANCE : transformer;
        }
        transformerArray = new Transformer[n];
        predicateArray = new Predicate[n];
        int n2 = 0;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            predicateArray[n2] = (Predicate)entry.getKey();
            transformerArray[n2] = (Transformer)entry.getValue();
            ++n2;
        }
        return new SwitchTransformer(predicateArray, transformerArray, transformer);
    }

    public SwitchTransformer(Predicate[] predicateArray, Transformer[] transformerArray, Transformer transformer) {
        this.iPredicates = predicateArray;
        this.iTransformers = transformerArray;
        this.iDefault = transformer == null ? ConstantTransformer.NULL_INSTANCE : transformer;
    }

    public Object transform(Object object) {
        for (int i = 0; i < this.iPredicates.length; ++i) {
            if (!this.iPredicates[i].evaluate(object)) continue;
            return this.iTransformers[i].transform(object);
        }
        return this.iDefault.transform(object);
    }
}

