/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.functors;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.collections.Factory;
import org.apache.commons.collections.FunctorException;
import org.apache.commons.collections.functors.ConstantFactory;
import org.apache.commons.collections.functors.InstantiateFactory;

public class PrototypeFactory {
    public static Factory getInstance(Object object) {
        if (object == null) {
            return ConstantFactory.NULL_INSTANCE;
        }
        try {
            Method method = object.getClass().getMethod("clone", null);
            return new PrototypeCloneFactory(object, method);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                object.getClass().getConstructor(object.getClass());
                return new InstantiateFactory(object.getClass(), new Class[]{object.getClass()}, new Object[]{object});
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                if (object instanceof Serializable) {
                    return new PrototypeSerializationFactory((Serializable)object);
                }
                throw new IllegalArgumentException("The prototype must be cloneable via a public clone method");
            }
        }
    }

    private PrototypeFactory() {
    }

    static class PrototypeSerializationFactory
    implements Factory,
    Serializable {
        static final long serialVersionUID = -8704966966139178833L;
        private final Serializable iPrototype;

        private PrototypeSerializationFactory(Serializable serializable) {
            this.iPrototype = serializable;
        }

        /*
         * Loose catch block
         * Enabled aggressive exception aggregation
         */
        public Object create() {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
            ByteArrayInputStream byteArrayInputStream = null;
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(this.iPrototype);
            byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            Object object = objectInputStream.readObject();
            Object var7_8 = null;
            try {
                if (byteArrayInputStream != null) {
                    byteArrayInputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            {
                return object;
                catch (ClassNotFoundException classNotFoundException) {
                    throw new FunctorException(classNotFoundException);
                }
                catch (IOException iOException) {
                    throw new FunctorException(iOException);
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    if (byteArrayInputStream != null) {
                        byteArrayInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    if (byteArrayOutputStream != null) {
                        byteArrayOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
    }

    static class PrototypeCloneFactory
    implements Factory,
    Serializable {
        static final long serialVersionUID = 5604271422565175555L;
        private final Object iPrototype;
        private transient Method iCloneMethod;

        private PrototypeCloneFactory(Object object, Method method) {
            this.iPrototype = object;
            this.iCloneMethod = method;
        }

        private void findCloneMethod() {
            try {
                this.iCloneMethod = this.iPrototype.getClass().getMethod("clone", null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IllegalArgumentException("PrototypeCloneFactory: The clone method must exist and be public ");
            }
        }

        public Object create() {
            if (this.iCloneMethod == null) {
                this.findCloneMethod();
            }
            try {
                return this.iCloneMethod.invoke(this.iPrototype, (Object[])null);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new FunctorException("PrototypeCloneFactory: Clone method must be public", illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new FunctorException("PrototypeCloneFactory: Clone method threw an exception", invocationTargetException);
            }
        }
    }
}

