/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.functors;

import java.io.Serializable;
import java.util.Collection;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.FunctorUtils;

public final class AnyPredicate
implements Predicate,
Serializable {
    static final long serialVersionUID = 7429999530934647542L;
    private final Predicate[] iPredicates;

    public static Predicate getInstance(Predicate[] predicateArray) {
        FunctorUtils.validateMin2(predicateArray);
        predicateArray = FunctorUtils.copy(predicateArray);
        return new AnyPredicate(predicateArray);
    }

    public static Predicate getInstance(Collection collection) {
        Predicate[] predicateArray = FunctorUtils.validate(collection);
        return new AnyPredicate(predicateArray);
    }

    public AnyPredicate(Predicate[] predicateArray) {
        this.iPredicates = predicateArray;
    }

    public boolean evaluate(Object object) {
        for (int i = 0; i < this.iPredicates.length; ++i) {
            if (!this.iPredicates[i].evaluate(object)) continue;
            return true;
        }
        return false;
    }
}

