/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.collection;

import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.collection.AbstractCollectionDecorator;

public class PredicatedCollection
extends AbstractCollectionDecorator {
    protected final Predicate predicate;

    public static Collection decorate(Collection collection, Predicate predicate) {
        return new PredicatedCollection(collection, predicate);
    }

    protected PredicatedCollection(Collection collection, Predicate predicate) {
        super(collection);
        if (predicate == null) {
            throw new IllegalArgumentException("Predicate must not be null");
        }
        this.predicate = predicate;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.validate(iterator.next());
        }
    }

    protected void validate(Object object) {
        if (!this.predicate.evaluate(object)) {
            throw new IllegalArgumentException("Cannot add Object '" + object + "' - Predicate rejected it");
        }
    }

    public boolean add(Object object) {
        this.validate(object);
        return this.getCollection().add(object);
    }

    public boolean addAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.validate(iterator.next());
        }
        return this.getCollection().addAll(collection);
    }
}

