/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.buffer;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.BufferUnderflowException;

public class UnboundedFifoBuffer
extends AbstractCollection
implements Buffer,
Serializable {
    private static final long serialVersionUID = -3482960336579541419L;
    protected transient Object[] buffer;
    protected transient int head;
    protected transient int tail;

    public UnboundedFifoBuffer() {
        this(32);
    }

    public UnboundedFifoBuffer(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("The size must be greater than 0");
        }
        this.buffer = new Object[n + 1];
        this.head = 0;
        this.tail = 0;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size());
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            objectOutputStream.writeObject(iterator.next());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.buffer = new Object[n];
        for (int i = 0; i < n; ++i) {
            this.buffer[i] = objectInputStream.readObject();
        }
        this.head = 0;
        this.tail = n;
    }

    public int size() {
        int n = 0;
        n = this.tail < this.head ? this.buffer.length - this.head + this.tail : this.tail - this.head;
        return n;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean add(Object object) {
        if (object == null) {
            throw new NullPointerException("Attempted to add null object to buffer");
        }
        if (this.size() + 1 >= this.buffer.length) {
            Object[] objectArray = new Object[(this.buffer.length - 1) * 2 + 1];
            int n = 0;
            int n2 = this.head;
            while (n2 != this.tail) {
                objectArray[n] = this.buffer[n2];
                this.buffer[n2] = null;
                ++n;
                if (++n2 != this.buffer.length) continue;
                n2 = 0;
            }
            this.buffer = objectArray;
            this.head = 0;
            this.tail = n;
        }
        this.buffer[this.tail] = object;
        ++this.tail;
        if (this.tail >= this.buffer.length) {
            this.tail = 0;
        }
        return true;
    }

    public Object get() {
        if (this.isEmpty()) {
            throw new BufferUnderflowException("The buffer is already empty");
        }
        return this.buffer[this.head];
    }

    public Object remove() {
        if (this.isEmpty()) {
            throw new BufferUnderflowException("The buffer is already empty");
        }
        Object object = this.buffer[this.head];
        if (null != object) {
            this.buffer[this.head] = null;
            ++this.head;
            if (this.head >= this.buffer.length) {
                this.head = 0;
            }
        }
        return object;
    }

    private int increment(int n) {
        if (++n >= this.buffer.length) {
            n = 0;
        }
        return n;
    }

    private int decrement(int n) {
        if (--n < 0) {
            n = this.buffer.length - 1;
        }
        return n;
    }

    public Iterator iterator() {
        return new Iterator(){
            private int index;
            private int lastReturnedIndex;
            {
                this.index = UnboundedFifoBuffer.this.head;
                this.lastReturnedIndex = -1;
            }

            public boolean hasNext() {
                return this.index != UnboundedFifoBuffer.this.tail;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.lastReturnedIndex = this.index;
                this.index = UnboundedFifoBuffer.this.increment(this.index);
                return UnboundedFifoBuffer.this.buffer[this.lastReturnedIndex];
            }

            public void remove() {
                if (this.lastReturnedIndex == -1) {
                    throw new IllegalStateException();
                }
                if (this.lastReturnedIndex == UnboundedFifoBuffer.this.head) {
                    UnboundedFifoBuffer.this.remove();
                    this.lastReturnedIndex = -1;
                    return;
                }
                int n = this.lastReturnedIndex + 1;
                while (n != UnboundedFifoBuffer.this.tail) {
                    if (n >= UnboundedFifoBuffer.this.buffer.length) {
                        UnboundedFifoBuffer.this.buffer[n - 1] = UnboundedFifoBuffer.this.buffer[0];
                        n = 0;
                        continue;
                    }
                    UnboundedFifoBuffer.this.buffer[n - 1] = UnboundedFifoBuffer.this.buffer[n];
                    ++n;
                }
                this.lastReturnedIndex = -1;
                UnboundedFifoBuffer.this.tail = UnboundedFifoBuffer.this.decrement(UnboundedFifoBuffer.this.tail);
                UnboundedFifoBuffer.this.buffer[UnboundedFifoBuffer.this.tail] = null;
                this.index = UnboundedFifoBuffer.this.decrement(this.index);
            }
        };
    }
}

