/*
 * Decompiled with CFR 0.152.
 */
package com.onionnetworks.dime;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;

public class DimeRecord {
    public static final long MAX_MAX_PAYLOAD_SIZE = 0xFFFFFFFFL;
    public static final int DEFAULT_MAX_PAYLOAD_SIZE = Integer.MAX_VALUE;
    public static final int VERSION = 1;
    private static final int VERSION_MASK = 248;
    private static final int VERSION_SHIFT = 3;
    private static final int MB_MASK = 4;
    private static final int ME_MASK = 2;
    private static final int CF_MASK = 1;
    private static final int TYPE_T_MASK = 240;
    private static final int TYPE_T_SHIFT = 4;
    private static final int RESERVED_MASK = 15;
    private TypeNameFormat tnf;
    private byte[] id;
    private byte[] type;
    private boolean first;
    private boolean last;
    private boolean continued;
    private long payloadLength = -1L;
    private InputStream payload;
    private SafeFiniteInputStream fis = null;
    private Random rand = new Random();

    public DimeRecord(byte[] byArray, TypeNameFormat typeNameFormat, String string, String string2) {
        this(new ByteArrayInputStream(byArray), byArray.length, typeNameFormat, string, string2);
    }

    public DimeRecord(InputStream inputStream, long l, TypeNameFormat typeNameFormat, String string, String string2) {
        this.tnf = typeNameFormat;
        this.type = string.getBytes();
        this.id = string2 != null ? string2.getBytes() : new byte[0];
        this.payloadLength = l;
        this.payload = inputStream;
    }

    protected static DimeRecord extract(InputStream inputStream) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = inputStream.read();
        if (n6 == -1) {
            throw new IOException("Unexpected end of stream");
        }
        boolean bl = (n6 & 2) != 0;
        boolean bl2 = (n6 & 1) != 0;
        boolean bl3 = (n6 & 4) != 0;
        int n7 = (n6 & 0xF8) >>> 3;
        if (n7 != 1) {
            throw new IOException("Unparsable Version: " + n7);
        }
        int n8 = inputStream.read();
        if (n8 == -1) {
            throw new IOException("Unexpected end of stream");
        }
        TypeNameFormat typeNameFormat = TypeNameFormat.get((n8 & 0xF0) >>> 4);
        if ((n8 & 0xF) != 0) {
            throw new IOException("Reserved header space must be all zero");
        }
        int n9 = DimeRecord.readUnsignedShort(inputStream);
        int n10 = DimeRecord.readUnsignedShort(inputStream);
        int n11 = DimeRecord.readUnsignedShort(inputStream);
        long l = DimeRecord.readUnsignedInt(inputStream);
        byte[] byArray = new byte[n9];
        for (n4 = 0; n4 < byArray.length; n4 += n5) {
            n5 = inputStream.read(byArray, n4, byArray.length - n4);
            if (n5 != -1) continue;
            throw new IOException("Unexpected end of stream");
        }
        byte[] byArray2 = new byte[(4 - n9 % 4) % 4];
        for (n4 = 0; n4 < byArray2.length; n4 += n3) {
            n3 = inputStream.read(byArray2, n4, byArray2.length - n4);
            if (n3 != -1) continue;
            throw new IOException("Unexpected end of stream");
        }
        byte[] byArray3 = new byte[n10];
        for (n4 = 0; n4 < byArray3.length; n4 += n2) {
            n2 = inputStream.read(byArray3, n4, byArray3.length - n4);
            if (n2 != -1) continue;
            throw new IOException("Unexpected end of stream");
        }
        byArray2 = new byte[(4 - n10 % 4) % 4];
        for (n4 = 0; n4 < byArray2.length; n4 += n2) {
            n2 = inputStream.read(byArray2, n4, byArray2.length - n4);
            if (n2 != -1) continue;
            throw new IOException("Unexpected end of stream");
        }
        byte[] byArray4 = new byte[n11];
        for (n4 = 0; n4 < byArray4.length; n4 += n) {
            n = inputStream.read(byArray4, n4, byArray4.length - n4);
            if (n != -1) continue;
            throw new IOException("Unexpected end of stream");
        }
        byArray2 = new byte[(4 - n11 % 4) % 4];
        for (n4 = 0; n4 < byArray2.length; n4 += n) {
            n = inputStream.read(byArray2, n4, byArray2.length - n4);
            if (n != -1) continue;
            throw new IOException("Unexpected end of stream");
        }
        DimeRecord dimeRecord = new DimeRecord(inputStream, l, typeNameFormat, new String(byArray4), new String(byArray3));
        dimeRecord.last = bl;
        dimeRecord.first = bl3;
        dimeRecord.continued = bl2;
        return dimeRecord;
    }

    protected synchronized void produce(OutputStream outputStream, long l, boolean bl, boolean bl2) throws IOException {
        if (this.payload == null) {
            throw new IllegalStateException("produce or getPayload already called");
        }
        if (l > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("payload size cannot be bigger than 4294967295");
        }
        byte[] byArray = this.id;
        byte[] byArray2 = this.type;
        TypeNameFormat typeNameFormat = this.tnf;
        for (long i = this.payloadLength; i > 0L; i -= l) {
            int n;
            int n2 = 1;
            n2 <<= 3;
            if (bl) {
                n2 |= 4;
                bl = false;
            }
            if (bl2 && i <= l) {
                n2 |= 2;
            }
            if (i > l) {
                n2 |= 1;
            }
            n2 <<= 4;
            n2 |= typeNameFormat.toInt();
            n2 <<= 4;
            outputStream.write(DimeRecord.getBytes(n2 <<= 16));
            n2 = 0;
            n2 |= byArray.length;
            n2 <<= 16;
            outputStream.write(DimeRecord.getBytes(n2 |= byArray2.length));
            long l2 = Math.min(l, i);
            outputStream.write(DimeRecord.getBytes((int)(0xFFFFFFFFL & l2)));
            outputStream.write(byArray);
            outputStream.write(this.getPad(byArray.length));
            outputStream.write(byArray2);
            outputStream.write(this.getPad(byArray2.length));
            byArray2 = new byte[]{};
            byArray = byArray2;
            typeNameFormat = TypeNameFormat.UNCHANGED;
            byte[] byArray3 = new byte[8192];
            for (long j = 0L; j < l2; j += (long)n) {
                n = this.payload.read(byArray3, 0, (int)Math.min((long)byArray3.length, l2 - j));
                if (n == -1) {
                    throw new IOException("Unexcepted end of payload");
                }
                outputStream.write(byArray3, 0, n);
            }
            outputStream.write(this.getPad(l2));
        }
        this.payload = null;
        outputStream.flush();
    }

    private static int readUnsignedShort(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        int n2 = inputStream.read();
        if (n == -1 || n2 == -1) {
            throw new IOException("unexpected end of stream");
        }
        return (n << 8) + n2;
    }

    private static long readUnsignedInt(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        int n2 = inputStream.read();
        int n3 = inputStream.read();
        int n4 = inputStream.read();
        if (n == -1 || n2 == -1 || n3 == -1 || n4 == -1) {
            throw new IOException("unexpected end of stream");
        }
        return n << 24 | n2 << 16 | n3 << 8 | n4;
    }

    private static String bytes(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 32; ++i) {
            stringBuffer.append((n & Integer.MIN_VALUE) >>> 31);
            n <<= 1;
            if ((i + 1) % 8 != 0) continue;
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    private byte[] getPad(long l) {
        byte[] byArray = new byte[(4 - (int)(l % 4L)) % 4];
        return byArray;
    }

    public synchronized InputStream getPayload() {
        if (this.payload == null) {
            throw new IllegalStateException("produce or getPayload already called");
        }
        InputStream inputStream = this.payload;
        this.payload = null;
        this.fis = new SafeFiniteInputStream(inputStream, this.payloadLength);
        return this.fis;
    }

    public long getPayloadLength() {
        return this.payloadLength;
    }

    public synchronized boolean isConsumed() {
        if (this.fis == null) {
            throw new IllegalStateException("Must call getPayload() first");
        }
        return this.fis.isDone();
    }

    public boolean isContinued() {
        return this.continued;
    }

    public String getId() {
        return this.id == null ? null : (this.id.length == 0 ? null : new String(this.id));
    }

    public String getType() {
        return this.type.length == 0 ? null : new String(this.type);
    }

    public TypeNameFormat getTypeNameFormat() {
        return this.tnf;
    }

    public boolean isLast() {
        return this.last;
    }

    public boolean isFirst() {
        return this.first;
    }

    public String toString() {
        return "DimeRecord(id='" + new String(this.id) + "', tnf='" + this.tnf + "', type='" + new String(this.type) + "', length=" + this.payloadLength + ", first=" + this.first + ", last=" + this.last + ", continued=" + this.continued + ")";
    }

    public static final byte[] getBytes(int n) {
        byte[] byArray = new byte[]{(byte)(n >>> 24 & 0xFF), (byte)(n >>> 16 & 0xFF), (byte)(n >>> 8 & 0xFF), (byte)(n & 0xFF)};
        return byArray;
    }

    public class SafeFiniteInputStream
    extends FilterInputStream {
        protected long left;
        int pad;

        public SafeFiniteInputStream(InputStream inputStream, long l) {
            super(inputStream);
            if (inputStream == null) {
                throw new NullPointerException();
            }
            if (l < 0L) {
                throw new IllegalArgumentException("count must be > 0");
            }
            this.left = l;
            this.pad = (4 - (int)(l % 4L)) % 4;
        }

        public void close() throws IOException {
            this.skip(this.left);
        }

        public long skip(long l) throws IOException {
            long l2 = this.in.skip(Math.min(l, this.left));
            this.left -= l2;
            this.checkDone();
            return l2;
        }

        public int read() throws IOException {
            byte[] byArray = new byte[1];
            if (this.read(byArray, 0, 1) == -1) {
                return -1;
            }
            return byArray[0] & 0xFF;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.left == 0L && n2 > 0) {
                return -1;
            }
            int n3 = this.in.read(byArray, n, (int)Math.min((long)n2, this.left));
            if (n3 < 0) {
                throw new EOFException();
            }
            this.left -= (long)n3;
            this.checkDone();
            return n3;
        }

        private synchronized void checkDone() throws IOException {
            while (this.left == 0L && this.pad != 0) {
                this.pad = (int)((long)this.pad - this.in.skip(this.pad));
            }
        }

        public synchronized boolean isDone() {
            return this.left == 0L && this.pad == 0;
        }

        public int available() throws IOException {
            return (int)Math.min((long)this.in.available(), this.left);
        }
    }

    public static class TypeNameFormat {
        public static final TypeNameFormat UNCHANGED = new TypeNameFormat(0);
        public static final TypeNameFormat MEDIA_TYPE = new TypeNameFormat(1);
        public static final TypeNameFormat URI = new TypeNameFormat(2);
        public static final TypeNameFormat UNKNOWN = new TypeNameFormat(3);
        public static final TypeNameFormat NONE = new TypeNameFormat(4);
        private int val;

        private TypeNameFormat(int n) {
            this.val = n;
        }

        public int toInt() {
            return this.val;
        }

        public static TypeNameFormat get(int n) {
            switch (n) {
                case 0: {
                    return UNCHANGED;
                }
                case 1: {
                    return MEDIA_TYPE;
                }
                case 2: {
                    return URI;
                }
                case 3: {
                    return UNKNOWN;
                }
                case 4: {
                    return NONE;
                }
            }
            throw new IllegalArgumentException("unrecognized value: " + n);
        }

        public boolean equals(Object object) {
            return object instanceof TypeNameFormat && ((TypeNameFormat)object).val == this.val;
        }

        public int hashCode() {
            return this.toInt();
        }

        public boolean isUnchanged() {
            return this.val == 0;
        }

        public boolean isMediaType() {
            return this.val == 1;
        }

        public boolean isUri() {
            return this.val == 2;
        }

        public boolean isUnknown() {
            return this.val == 3;
        }

        public boolean isNone() {
            return this.val == 4;
        }

        public String toString() {
            switch (this.val) {
                case 0: {
                    return "unchanged";
                }
                case 1: {
                    return "media_type";
                }
                case 2: {
                    return "uri";
                }
                case 3: {
                    return "unknown";
                }
                case 4: {
                    return "none";
                }
            }
            throw new IllegalStateException("Unknown value");
        }
    }
}

