/*
 * Decompiled with CFR 0.152.
 */
package com.onionnetworks.dime;

import com.onionnetworks.dime.DimeRecord;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class DimeParser
implements Iterator {
    private Object nextStoplight = new Object();
    private InputStream in;
    private DimeRecord prev = null;

    public DimeParser(InputStream inputStream) {
        this.in = inputStream;
    }

    public synchronized Object next() {
        try {
            return this.nextRecord();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new NoSuchElementException("IOException");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized DimeRecord nextRecord() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Last Message already returned");
        }
        if (this.prev != null) {
            DimeRecord dimeRecord = this.prev;
            synchronized (dimeRecord) {
                if (!this.prev.isConsumed()) {
                    throw new IllegalStateException("No seconds until you clear your plate.");
                }
            }
        }
        this.prev = DimeRecord.extract(this.in);
        return this.prev;
    }

    public synchronized boolean hasNext() {
        return this.prev == null || !this.prev.isLast();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static void main(String[] stringArray) throws Exception {
        DimeParser dimeParser = new DimeParser(new FileInputStream(new File(stringArray[0])));
        int n = 0;
        int n2 = 0;
        FileOutputStream fileOutputStream = null;
        while (dimeParser.hasNext()) {
            int n3;
            System.out.println("-----[ Record: " + n++);
            DimeRecord dimeRecord = dimeParser.nextRecord();
            long l = dimeRecord.getPayloadLength();
            System.out.println("Payload Length: " + l);
            System.out.println("Id: " + dimeRecord.getId());
            System.out.println("Type: " + new String(dimeRecord.getType() != null ? dimeRecord.getType() : "<null>"));
            System.out.println("TNF: " + dimeRecord.getTypeNameFormat().toInt());
            System.out.println("First:" + dimeRecord.isFirst());
            System.out.println("Last:" + dimeRecord.isLast());
            System.out.println("Continued:" + dimeRecord.isContinued());
            if (fileOutputStream == null) {
                fileOutputStream = new FileOutputStream(new File("part-" + ++n2));
            }
            byte[] byArray = new byte[8192];
            InputStream inputStream = dimeRecord.getPayload();
            while ((n3 = inputStream.read(byArray, 0, byArray.length)) != -1) {
                fileOutputStream.write(byArray, 0, n3);
            }
            if (!dimeRecord.isContinued()) {
                fileOutputStream.flush();
                fileOutputStream.close();
                fileOutputStream = null;
            }
            System.out.println("Payload: <part-" + n2 + ">");
        }
    }
}

