/*
 * Decompiled with CFR 0.152.
 */
package com.onionnetworks.dime;

import com.onionnetworks.dime.DimeRecord;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;

public class DimeGenerator {
    private long autoChunkSize;
    private OutputStream out;
    private boolean first;
    private boolean last;
    private HashSet ids;

    public DimeGenerator(OutputStream outputStream) {
        this(outputStream, Integer.MAX_VALUE);
    }

    public DimeGenerator(OutputStream outputStream, long l) {
        if (l > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("auto chunk size cannot be bigger than 4294967295");
        }
        this.autoChunkSize = l;
        this.out = outputStream;
        this.ids = new HashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRecord(DimeRecord dimeRecord, boolean bl) throws IOException {
        if (this.last) {
            throw new IllegalStateException("DIME message closed");
        }
        if (bl) {
            this.last = true;
        }
        if (dimeRecord.getId() != null) {
            HashSet hashSet = this.ids;
            synchronized (hashSet) {
                if (this.ids.contains(dimeRecord.getId())) {
                    throw new IllegalStateException("Two records can't have the same id");
                }
                this.ids.add(dimeRecord.getId());
            }
        }
        dimeRecord.produce(this.out, this.autoChunkSize, this.first ? false : (this.first = true), bl);
    }

    public static void main(String[] stringArray) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(new File("output.dime"));
        DimeGenerator dimeGenerator = new DimeGenerator(fileOutputStream);
        String string = "Ry4an type";
        for (int i = 0; i < stringArray.length; ++i) {
            File file = new File(stringArray[i]);
            DimeRecord dimeRecord = new DimeRecord(new FileInputStream(file), file.length(), DimeRecord.TypeNameFormat.UNKNOWN, string, null);
            dimeGenerator.addRecord(dimeRecord, i == stringArray.length - 1);
            System.out.println("Added: " + dimeRecord);
        }
        fileOutputStream.flush();
        fileOutputStream.close();
    }
}

