/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;

public class PercentLayout
implements LayoutManager2 {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private static final Constraint REMAINING_SPACE = new Constraint("*");
    private static final Constraint PREFERRED_SIZE = new Constraint("");
    private int orientation;
    private int gap;
    private Hashtable m_ComponentToConstraint;

    public PercentLayout() {
        this(0, 0);
    }

    public PercentLayout(int n, int n2) {
        this.setOrientation(n);
        this.gap = n2;
        this.m_ComponentToConstraint = new Hashtable();
    }

    public void setGap(int n) {
        this.gap = n;
    }

    public int getGap() {
        return this.gap;
    }

    public void setOrientation(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Orientation must be one of HORIZONTAL or VERTICAL");
        }
        this.orientation = n;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public Constraint getConstraint(Component component) {
        return (Constraint)this.m_ComponentToConstraint.get(component);
    }

    public void setConstraint(Component component, Object object) {
        if (object instanceof Constraint) {
            this.m_ComponentToConstraint.put(component, object);
        } else if (object instanceof Number) {
            this.setConstraint(component, new NumberConstraint(((Number)object).intValue()));
        } else if ("*".equals(object)) {
            this.setConstraint(component, REMAINING_SPACE);
        } else if ("".equals(object)) {
            this.setConstraint(component, PREFERRED_SIZE);
        } else if (object instanceof String) {
            String string = (String)object;
            if (string.endsWith("%")) {
                float f = Float.valueOf(string.substring(0, string.length() - 1)).floatValue() / 100.0f;
                if (f > 1.0f || f < 0.0f) {
                    throw new IllegalArgumentException("percent value must be >= 0 and <= 100");
                }
                this.setConstraint(component, new PercentConstraint(f));
            } else {
                this.setConstraint(component, new NumberConstraint(Integer.valueOf(string)));
            }
        } else if (object == null) {
            this.setConstraint(component, PREFERRED_SIZE);
        } else {
            throw new IllegalArgumentException("Invalid Constraint");
        }
    }

    public void addLayoutComponent(Component component, Object object) {
        this.setConstraint(component, object);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void invalidateLayout(Container container) {
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
        this.m_ComponentToConstraint.remove(component);
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public Dimension preferredLayoutSize(Container container) {
        Component[] componentArray = container.getComponents();
        Insets insets = container.getInsets();
        int n = 0;
        int n2 = 0;
        boolean bl = true;
        int n3 = componentArray.length;
        for (int i = 0; i < n3; ++i) {
            if (!componentArray[i].isVisible()) continue;
            Dimension dimension = componentArray[i].getPreferredSize();
            if (this.orientation == 0) {
                n2 = Math.max(n2, dimension.height);
                n += dimension.width;
                if (bl) {
                    bl = false;
                    continue;
                }
                n += this.gap;
                continue;
            }
            n2 += dimension.height;
            n = Math.max(n, dimension.width);
            if (bl) {
                bl = false;
                continue;
            }
            n2 += this.gap;
        }
        return new Dimension(n + insets.right + insets.left, n2 + insets.top + insets.bottom);
    }

    public void layoutContainer(Container container) {
        int n;
        int n2;
        Insets insets = container.getInsets();
        Dimension dimension = container.getSize();
        dimension.width = dimension.width - insets.left - insets.right;
        dimension.height = dimension.height - insets.top - insets.bottom;
        Component[] componentArray = container.getComponents();
        int[] nArray = new int[componentArray.length];
        int n3 = n2 = (0 == this.orientation ? dimension.width : dimension.height) - (componentArray.length - 1) * this.gap;
        int n4 = componentArray.length;
        for (n = 0; n < n4; ++n) {
            if (!componentArray[n].isVisible()) continue;
            Constraint constraint = (Constraint)this.m_ComponentToConstraint.get(componentArray[n]);
            if (constraint == null || constraint == PREFERRED_SIZE) {
                nArray[n] = 0 == this.orientation ? componentArray[n].getPreferredSize().width : componentArray[n].getPreferredSize().height;
                n3 -= nArray[n];
                continue;
            }
            if (!(constraint instanceof NumberConstraint)) continue;
            nArray[n] = ((NumberConstraint)constraint).intValue();
            n3 -= nArray[n];
        }
        n = n3;
        int n5 = componentArray.length;
        for (n4 = 0; n4 < n5; ++n4) {
            Constraint constraint;
            if (!componentArray[n4].isVisible() || !((constraint = (Constraint)this.m_ComponentToConstraint.get(componentArray[n4])) instanceof PercentConstraint)) continue;
            nArray[n4] = (int)((float)n * ((PercentConstraint)constraint).floatValue());
            n3 -= nArray[n4];
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n6 = componentArray.length;
        for (n5 = 0; n5 < n6; ++n5) {
            Constraint constraint;
            if (!componentArray[n5].isVisible() || (constraint = (Constraint)this.m_ComponentToConstraint.get(componentArray[n5])) != REMAINING_SPACE) continue;
            arrayList.add(new Integer(n5));
            nArray[n5] = 0;
        }
        if (arrayList.size() > 0) {
            n5 = n3 / arrayList.size();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                nArray[((Integer)iterator.next()).intValue()] = n5;
            }
        }
        n5 = 0 == this.orientation ? insets.left : insets.top;
        int n7 = componentArray.length;
        for (int i = 0; i < n7; ++i) {
            if (!componentArray[i].isVisible()) continue;
            if (0 == this.orientation) {
                componentArray[i].setBounds(n5, insets.top, nArray[i], dimension.height);
            } else {
                componentArray[i].setBounds(insets.left, n5, dimension.width, nArray[i]);
            }
            n5 += this.gap + nArray[i];
        }
    }

    static class PercentConstraint
    extends Constraint {
        public PercentConstraint(float f) {
            super(new Float(f));
        }

        public float floatValue() {
            return ((Float)this.value).floatValue();
        }
    }

    static class NumberConstraint
    extends Constraint {
        public NumberConstraint(int n) {
            this(new Integer(n));
        }

        public NumberConstraint(Integer n) {
            super(n);
        }

        public int intValue() {
            return (Integer)this.value;
        }
    }

    static class Constraint {
        protected Object value;

        private Constraint(Object object) {
            this.value = object;
        }
    }
}

