/*
 * Decompiled with CFR 0.152.
 */
package com.bitzi.util;

import java.security.DigestException;
import java.security.MessageDigest;

public final class SHA1
extends MessageDigest
implements Cloneable {
    private long bytes;
    private int padded;
    private byte[] pad = new byte[64];
    private int hA;
    private int hB;
    private int hC;
    private int hD;
    private int hE;

    public SHA1() {
        super("SHA-1");
        this.init();
    }

    public Object clone() throws CloneNotSupportedException {
        SHA1 sHA1 = (SHA1)super.clone();
        sHA1.pad = (byte[])this.pad.clone();
        return sHA1;
    }

    public void engineReset() {
        int n = 60;
        byte[] byArray = this.pad;
        do {
            byArray[n - 4] = 0;
            byArray[n - 3] = 0;
            byArray[n - 2] = 0;
            byArray[n - 1] = 0;
            byArray[n] = 0;
            byArray[n + 1] = 0;
            byArray[n + 2] = 0;
            byArray[n + 3] = 0;
        } while ((n -= 8) >= 0);
        this.padded = 0;
        this.bytes = 0L;
        this.init();
    }

    protected void init() {
        this.hA = 1732584193;
        this.hB = -271733879;
        this.hC = -1732584194;
        this.hD = 271733878;
        this.hE = -1009589776;
    }

    public void engineUpdate(byte by) {
        ++this.bytes;
        if (this.padded < 63) {
            this.pad[this.padded++] = by;
            return;
        }
        this.pad[63] = by;
        this.padded = 0;
        this.computeBlock(this.pad, 0);
    }

    public void engineUpdate(byte[] byArray, int n, int n2) {
        if (n >= 0 && n2 >= 0 && n + n2 <= byArray.length) {
            this.bytes += (long)n2;
            if (this.padded > 0 && this.padded + n2 >= 64) {
                int n3 = 64 - this.padded;
                System.arraycopy(byArray, n, this.pad, this.padded, n3);
                this.padded = 0;
                this.computeBlock(this.pad, 0);
                n += n3;
                n2 -= n3;
            }
            while (n2 >= 512) {
                this.computeBlock(byArray, n);
                this.computeBlock(byArray, n + 64);
                this.computeBlock(byArray, n + 128);
                this.computeBlock(byArray, n + 192);
                this.computeBlock(byArray, n + 256);
                this.computeBlock(byArray, n + 320);
                this.computeBlock(byArray, n + 384);
                this.computeBlock(byArray, n + 448);
                n += 512;
                n2 -= 512;
            }
            while (n2 >= 64) {
                this.computeBlock(byArray, n);
                n += 64;
                n2 -= 64;
            }
            if (n2 > 0) {
                System.arraycopy(byArray, n, this.pad, this.padded, n2);
                this.padded += n2;
            }
            return;
        }
        throw new ArrayIndexOutOfBoundsException(n);
    }

    public byte[] engineDigest() {
        try {
            byte[] byArray = new byte[20];
            this.engineDigest(byArray, 0, 20);
            return byArray;
        }
        catch (DigestException digestException) {
            return null;
        }
    }

    public int engineGetDigestLength() {
        return 20;
    }

    public int engineDigest(byte[] byArray, int n, int n2) throws DigestException {
        if (n2 >= 20) {
            if (byArray.length - n >= 20) {
                byte[] byArray2 = this.pad;
                int n3 = this.padded;
                this.pad[n3] = -128;
                switch (n3) {
                    case 56: {
                        byArray2[57] = 0;
                    }
                    case 57: {
                        byArray2[58] = 0;
                    }
                    case 58: {
                        byArray2[59] = 0;
                    }
                    case 59: {
                        byArray2[60] = 0;
                    }
                    case 60: {
                        byArray2[61] = 0;
                    }
                    case 61: {
                        byArray2[62] = 0;
                    }
                    case 62: {
                        byArray2[63] = 0;
                    }
                    case 63: {
                        this.computeBlock(byArray2, 0);
                        n3 = -1;
                    }
                }
                switch (n3 & 7) {
                    case 7: {
                        n3 -= 3;
                        break;
                    }
                    case 6: {
                        byArray2[(n3 -= 2) + 3] = 0;
                        break;
                    }
                    case 5: {
                        byArray2[--n3 + 2] = 0;
                        byArray2[n3 + 3] = 0;
                        break;
                    }
                    case 4: {
                        byArray2[n3 + 1] = 0;
                        byArray2[n3 + 2] = 0;
                        byArray2[n3 + 3] = 0;
                        break;
                    }
                    case 3: {
                        byArray2[++n3] = 0;
                        byArray2[n3 + 1] = 0;
                        byArray2[n3 + 2] = 0;
                        byArray2[n3 + 3] = 0;
                        break;
                    }
                    case 2: {
                        byArray2[(n3 += 2) - 1] = 0;
                        byArray2[n3] = 0;
                        byArray2[n3 + 1] = 0;
                        byArray2[n3 + 2] = 0;
                        byArray2[n3 + 3] = 0;
                        break;
                    }
                    case 1: {
                        byArray2[(n3 += 3) - 2] = 0;
                        byArray2[n3 - 1] = 0;
                        byArray2[n3] = 0;
                        byArray2[n3 + 1] = 0;
                        byArray2[n3 + 2] = 0;
                        byArray2[n3 + 3] = 0;
                        break;
                    }
                    case 0: {
                        byArray2[(n3 += 4) - 3] = 0;
                        byArray2[n3 - 2] = 0;
                        byArray2[n3 - 1] = 0;
                        byArray2[n3] = 0;
                        byArray2[n3 + 1] = 0;
                        byArray2[n3 + 2] = 0;
                        byArray2[n3 + 3] = 0;
                    }
                }
                while ((n3 += 8) <= 52) {
                    byArray2[n3 - 4] = 0;
                    byArray2[n3 - 3] = 0;
                    byArray2[n3 - 2] = 0;
                    byArray2[n3 - 1] = 0;
                    byArray2[n3] = 0;
                    byArray2[n3 + 1] = 0;
                    byArray2[n3 + 2] = 0;
                    byArray2[n3 + 3] = 0;
                }
                n3 = (int)(this.bytes >>> 29);
                byArray2[56] = (byte)(n3 >> 24);
                byArray2[57] = (byte)(n3 >>> 16);
                byArray2[58] = (byte)(n3 >>> 8);
                byArray2[59] = (byte)n3;
                n3 = (int)this.bytes << 3;
                byArray2[60] = (byte)(n3 >> 24);
                byArray2[61] = (byte)(n3 >>> 16);
                byArray2[62] = (byte)(n3 >>> 8);
                byArray2[63] = (byte)n3;
                this.computeBlock(this.pad, 0);
                n3 = this.hA;
                byArray[n] = (byte)(n3 >>> 24);
                byArray[n + 1] = (byte)(n3 >>> 16);
                byArray[n + 2] = (byte)(n3 >>> 8);
                byArray[n + 3] = (byte)n3;
                n3 = this.hB;
                byArray[n + 4] = (byte)(n3 >>> 24);
                byArray[n + 5] = (byte)(n3 >>> 16);
                byArray[(n += 10) - 4] = (byte)(n3 >>> 8);
                byArray[n - 3] = (byte)n3;
                n3 = this.hC;
                byArray[n - 2] = (byte)(n3 >>> 24);
                byArray[n - 1] = (byte)(n3 >>> 16);
                byArray[n] = (byte)(n3 >>> 8);
                byArray[n + 1] = (byte)n3;
                n3 = this.hD;
                byArray[n + 2] = (byte)(n3 >>> 24);
                byArray[n + 3] = (byte)(n3 >>> 16);
                byArray[n + 4] = (byte)(n3 >>> 8);
                byArray[n + 5] = (byte)n3;
                n3 = this.hE;
                byArray[n += 6] = (byte)(n3 >>> 24);
                byArray[n + 1] = (byte)(n3 >>> 16);
                byArray[n + 2] = (byte)(n3 >>> 8);
                byArray[n + 3] = (byte)n3;
                this.engineReset();
                return 20;
            }
            throw new DigestException("insufficient space in output buffer to store the digest");
        }
        throw new DigestException("partial digests not returned");
    }

    private void computeBlock(byte[] byArray, int n) {
        int n2 = byArray[n] << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
        int n3 = this.hC;
        int n4 = this.hD;
        int n5 = this.hB;
        int n6 = this.hA;
        int n7 = n2 + ((n3 ^ n4) & n5 ^ n4) + (n6 << 5 | n6 >>> 27) + 1518500249 + this.hE;
        int n8 = byArray[n + 4] << 24 | (byArray[n + 5] & 0xFF) << 16 | (byArray[(n += 10) - 4] & 0xFF) << 8 | byArray[n - 3] & 0xFF;
        n5 = n5 << 30 | n5 >>> 2;
        n4 = n8 + ((n5 ^ n3) & n6 ^ n3) + (n7 << 5 | n7 >>> 27) + 1518500249 + n4;
        int n9 = byArray[n - 2] << 24 | (byArray[n - 1] & 0xFF) << 16 | (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
        n6 = n6 << 30 | n6 >>> 2;
        n3 = n9 + ((n6 ^ n5) & n7 ^ n5) + (n4 << 5 | n4 >>> 27) + 1518500249 + n3;
        int n10 = byArray[n + 2] << 24 | (byArray[n + 3] & 0xFF) << 16 | (byArray[n + 4] & 0xFF) << 8 | byArray[n + 5] & 0xFF;
        n7 = n7 << 30 | n7 >>> 2;
        n5 = n10 + ((n7 ^ n6) & n4 ^ n6) + (n3 << 5 | n3 >>> 27) + 1518500249 + n5;
        int n11 = byArray[(n += 10) - 4] << 24 | (byArray[n - 3] & 0xFF) << 16 | (byArray[n - 2] & 0xFF) << 8 | byArray[n - 1] & 0xFF;
        n4 = n4 << 30 | n4 >>> 2;
        n6 = n11 + ((n4 ^ n7) & n3 ^ n7) + (n5 << 5 | n5 >>> 27) + 1518500249 + n6;
        int n12 = byArray[n] << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
        n3 = n3 << 30 | n3 >>> 2;
        n7 = n12 + ((n3 ^ n4) & n5 ^ n4) + (n6 << 5 | n6 >>> 27) + 1518500249 + n7;
        int n13 = byArray[n + 4] << 24 | (byArray[n + 5] & 0xFF) << 16 | (byArray[(n += 10) - 4] & 0xFF) << 8 | byArray[n - 3] & 0xFF;
        n5 = n5 << 30 | n5 >>> 2;
        n4 = n13 + ((n5 ^ n3) & n6 ^ n3) + (n7 << 5 | n7 >>> 27) + 1518500249 + n4;
        int n14 = byArray[n - 2] << 24 | (byArray[n - 1] & 0xFF) << 16 | (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
        n6 = n6 << 30 | n6 >>> 2;
        n3 = n14 + ((n6 ^ n5) & n7 ^ n5) + (n4 << 5 | n4 >>> 27) + 1518500249 + n3;
        int n15 = byArray[n + 2] << 24 | (byArray[n + 3] & 0xFF) << 16 | (byArray[n + 4] & 0xFF) << 8 | byArray[n + 5] & 0xFF;
        n7 = n7 << 30 | n7 >>> 2;
        n5 = n15 + ((n7 ^ n6) & n4 ^ n6) + (n3 << 5 | n3 >>> 27) + 1518500249 + n5;
        int n16 = byArray[(n += 10) - 4] << 24 | (byArray[n - 3] & 0xFF) << 16 | (byArray[n - 2] & 0xFF) << 8 | byArray[n - 1] & 0xFF;
        n4 = n4 << 30 | n4 >>> 2;
        n6 = n16 + ((n4 ^ n7) & n3 ^ n7) + (n5 << 5 | n5 >>> 27) + 1518500249 + n6;
        int n17 = byArray[n] << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
        n3 = n3 << 30 | n3 >>> 2;
        n7 = n17 + ((n3 ^ n4) & n5 ^ n4) + (n6 << 5 | n6 >>> 27) + 1518500249 + n7;
        int n18 = byArray[n + 4] << 24 | (byArray[n + 5] & 0xFF) << 16 | (byArray[(n += 10) - 4] & 0xFF) << 8 | byArray[n - 3] & 0xFF;
        n5 = n5 << 30 | n5 >>> 2;
        n4 = n18 + ((n5 ^ n3) & n6 ^ n3) + (n7 << 5 | n7 >>> 27) + 1518500249 + n4;
        int n19 = byArray[n - 2] << 24 | (byArray[n - 1] & 0xFF) << 16 | (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
        n6 = n6 << 30 | n6 >>> 2;
        n3 = n19 + ((n6 ^ n5) & n7 ^ n5) + (n4 << 5 | n4 >>> 27) + 1518500249 + n3;
        int n20 = byArray[n + 2] << 24 | (byArray[n + 3] & 0xFF) << 16 | (byArray[n + 4] & 0xFF) << 8 | byArray[n + 5] & 0xFF;
        n7 = n7 << 30 | n7 >>> 2;
        n5 = n20 + ((n7 ^ n6) & n4 ^ n6) + (n3 << 5 | n3 >>> 27) + 1518500249 + n5;
        int n21 = byArray[(n += 10) - 4] << 24 | (byArray[n - 3] & 0xFF) << 16 | (byArray[n - 2] & 0xFF) << 8 | byArray[n - 1] & 0xFF;
        n4 = n4 << 30 | n4 >>> 2;
        n6 = n21 + ((n4 ^ n7) & n3 ^ n7) + (n5 << 5 | n5 >>> 27) + 1518500249 + n6;
        int n22 = byArray[n] << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
        n3 = n3 << 30 | n3 >>> 2;
        n7 = n22 + ((n3 ^ n4) & n5 ^ n4) + (n6 << 5 | n6 >>> 27) + 1518500249 + n7;
        n2 = n2 ^ n9 ^ n15 ^ n20;
        n2 = n2 << 1 | n2 >>> 31;
        n5 = n5 << 30 | n5 >>> 2;
        n4 = n2 + ((n5 ^ n3) & n6 ^ n3) + (n7 << 5 | n7 >>> 27) + 1518500249 + n4;
        n8 = n8 ^ n10 ^ n16 ^ n21;
        n8 = n8 << 1 | n8 >>> 31;
        n6 = n6 << 30 | n6 >>> 2;
        n3 = n8 + ((n6 ^ n5) & n7 ^ n5) + (n4 << 5 | n4 >>> 27) + 1518500249 + n3;
        n9 = n9 ^ n11 ^ n17 ^ n22;
        n9 = n9 << 1 | n9 >>> 31;
        n7 = n7 << 30 | n7 >>> 2;
        n5 = n9 + ((n7 ^ n6) & n4 ^ n6) + (n3 << 5 | n3 >>> 27) + 1518500249 + n5;
        n10 = n10 ^ n12 ^ n18 ^ n2;
        n10 = n10 << 1 | n10 >>> 31;
        n4 = n4 << 30 | n4 >>> 2;
        n6 = n10 + ((n4 ^ n7) & n3 ^ n7) + (n5 << 5 | n5 >>> 27) + 1518500249 + n6;
        n11 = n11 ^ n13 ^ n19 ^ n8;
        n11 = n11 << 1 | n11 >>> 31;
        n3 = n3 << 30 | n3 >>> 2;
        n7 = n11 + (n3 ^ n5 ^ n4) + (n6 << 5 | n6 >>> 27) + 1859775393 + n7;
        n12 = n12 ^ n14 ^ n20 ^ n9;
        n12 = n12 << 1 | n12 >>> 31;
        n5 = n5 << 30 | n5 >>> 2;
        n4 = n12 + (n5 ^ n6 ^ n3) + (n7 << 5 | n7 >>> 27) + 1859775393 + n4;
        n13 = n13 ^ n15 ^ n21 ^ n10;
        n13 = n13 << 1 | n13 >>> 31;
        n6 = n6 << 30 | n6 >>> 2;
        n3 = n13 + (n6 ^ n7 ^ n5) + (n4 << 5 | n4 >>> 27) + 1859775393 + n3;
        n14 = n14 ^ n16 ^ n22 ^ n11;
        n14 = n14 << 1 | n14 >>> 31;
        n7 = n7 << 30 | n7 >>> 2;
        n5 = n14 + (n7 ^ n4 ^ n6) + (n3 << 5 | n3 >>> 27) + 1859775393 + n5;
        n15 = n15 ^ n17 ^ n2 ^ n12;
        n15 = n15 << 1 | n15 >>> 31;
        n4 = n4 << 30 | n4 >>> 2;
        n6 = n15 + (n4 ^ n3 ^ n7) + (n5 << 5 | n5 >>> 27) + 1859775393 + n6;
        n16 = n16 ^ n18 ^ n8 ^ n13;
        n16 = n16 << 1 | n16 >>> 31;
        n3 = n3 << 30 | n3 >>> 2;
        n7 = n16 + (n3 ^ n5 ^ n4) + (n6 << 5 | n6 >>> 27) + 1859775393 + n7;
        n17 = n17 ^ n19 ^ n9 ^ n14;
        n17 = n17 << 1 | n17 >>> 31;
        n5 = n5 << 30 | n5 >>> 2;
        n4 = n17 + (n5 ^ n6 ^ n3) + (n7 << 5 | n7 >>> 27) + 1859775393 + n4;
        n18 = n18 ^ n20 ^ n10 ^ n15;
        n18 = n18 << 1 | n18 >>> 31;
        n6 = n6 << 30 | n6 >>> 2;
        n3 = n18 + (n6 ^ n7 ^ n5) + (n4 << 5 | n4 >>> 27) + 1859775393 + n3;
        n19 = n19 ^ n21 ^ n11 ^ n16;
        n19 = n19 << 1 | n19 >>> 31;
        n7 = n7 << 30 | n7 >>> 2;
        n5 = n19 + (n7 ^ n4 ^ n6) + (n3 << 5 | n3 >>> 27) + 1859775393 + n5;
        n20 = n20 ^ n22 ^ n12 ^ n17;
        n20 = n20 << 1 | n20 >>> 31;
        n4 = n4 << 30 | n4 >>> 2;
        n6 = n20 + (n4 ^ n3 ^ n7) + (n5 << 5 | n5 >>> 27) + 1859775393 + n6;
        n21 = n21 ^ n2 ^ n13 ^ n18;
        n21 = n21 << 1 | n21 >>> 31;
        n3 = n3 << 30 | n3 >>> 2;
        n7 = n21 + (n3 ^ n5 ^ n4) + (n6 << 5 | n6 >>> 27) + 1859775393 + n7;
        n22 = n22 ^ n8 ^ n14 ^ n19;
        n22 = n22 << 1 | n22 >>> 31;
        n5 = n5 << 30 | n5 >>> 2;
        n4 = n22 + (n5 ^ n6 ^ n3) + (n7 << 5 | n7 >>> 27) + 1859775393 + n4;
        n2 = n2 ^ n9 ^ n15 ^ n20;
        n2 = n2 << 1 | n2 >>> 31;
        n6 = n6 << 30 | n6 >>> 2;
        n3 = n2 + (n6 ^ n7 ^ n5) + (n4 << 5 | n4 >>> 27) + 1859775393 + n3;
        n8 = n8 ^ n10 ^ n16 ^ n21;
        n8 = n8 << 1 | n8 >>> 31;
        n7 = n7 << 30 | n7 >>> 2;
        n5 = n8 + (n7 ^ n4 ^ n6) + (n3 << 5 | n3 >>> 27) + 1859775393 + n5;
        n9 = n9 ^ n11 ^ n17 ^ n22;
        n9 = n9 << 1 | n9 >>> 31;
        n4 = n4 << 30 | n4 >>> 2;
        n6 = n9 + (n4 ^ n3 ^ n7) + (n5 << 5 | n5 >>> 27) + 1859775393 + n6;
        n10 = n10 ^ n12 ^ n18 ^ n2;
        n10 = n10 << 1 | n10 >>> 31;
        n3 = n3 << 30 | n3 >>> 2;
        n7 = n10 + (n3 ^ n5 ^ n4) + (n6 << 5 | n6 >>> 27) + 1859775393 + n7;
        n11 = n11 ^ n13 ^ n19 ^ n8;
        n11 = n11 << 1 | n11 >>> 31;
        n5 = n5 << 30 | n5 >>> 2;
        n4 = n11 + (n5 ^ n6 ^ n3) + (n7 << 5 | n7 >>> 27) + 1859775393 + n4;
        n12 = n12 ^ n14 ^ n20 ^ n9;
        n12 = n12 << 1 | n12 >>> 31;
        n6 = n6 << 30 | n6 >>> 2;
        n3 = n12 + (n6 ^ n7 ^ n5) + (n4 << 5 | n4 >>> 27) + 1859775393 + n3;
        n13 = n13 ^ n15 ^ n21 ^ n10;
        n13 = n13 << 1 | n13 >>> 31;
        n7 = n7 << 30 | n7 >>> 2;
        n5 = n13 + (n7 ^ n4 ^ n6) + (n3 << 5 | n3 >>> 27) + 1859775393 + n5;
        n14 = n14 ^ n16 ^ n22 ^ n11;
        n14 = n14 << 1 | n14 >>> 31;
        n4 = n4 << 30 | n4 >>> 2;
        n6 = n14 + (n4 ^ n3 ^ n7) + (n5 << 5 | n5 >>> 27) + 1859775393 + n6;
        n15 = n15 ^ n17 ^ n2 ^ n12;
        n15 = n15 << 1 | n15 >>> 31;
        n3 = n3 << 30 | n3 >>> 2;
        n7 = n15 + ((n3 | n5) & n4 | n3 & n5) + (n6 << 5 | n6 >>> 27) + -1894007588 + n7;
        n16 = n16 ^ n18 ^ n8 ^ n13;
        n16 = n16 << 1 | n16 >>> 31;
        n5 = n5 << 30 | n5 >>> 2;
        n4 = n16 + ((n5 | n6) & n3 | n5 & n6) + (n7 << 5 | n7 >>> 27) + -1894007588 + n4;
        n17 = n17 ^ n19 ^ n9 ^ n14;
        n17 = n17 << 1 | n17 >>> 31;
        n6 = n6 << 30 | n6 >>> 2;
        n3 = n17 + ((n6 | n7) & n5 | n6 & n7) + (n4 << 5 | n4 >>> 27) + -1894007588 + n3;
        n18 = n18 ^ n20 ^ n10 ^ n15;
        n18 = n18 << 1 | n18 >>> 31;
        n7 = n7 << 30 | n7 >>> 2;
        n5 = n18 + ((n7 | n4) & n6 | n7 & n4) + (n3 << 5 | n3 >>> 27) + -1894007588 + n5;
        n19 = n19 ^ n21 ^ n11 ^ n16;
        n19 = n19 << 1 | n19 >>> 31;
        n4 = n4 << 30 | n4 >>> 2;
        n6 = n19 + ((n4 | n3) & n7 | n4 & n3) + (n5 << 5 | n5 >>> 27) + -1894007588 + n6;
        n20 = n20 ^ n22 ^ n12 ^ n17;
        n20 = n20 << 1 | n20 >>> 31;
        n3 = n3 << 30 | n3 >>> 2;
        n7 = n20 + ((n3 | n5) & n4 | n3 & n5) + (n6 << 5 | n6 >>> 27) + -1894007588 + n7;
        n21 = n21 ^ n2 ^ n13 ^ n18;
        n21 = n21 << 1 | n21 >>> 31;
        n5 = n5 << 30 | n5 >>> 2;
        n4 = n21 + ((n5 | n6) & n3 | n5 & n6) + (n7 << 5 | n7 >>> 27) + -1894007588 + n4;
        n22 = n22 ^ n8 ^ n14 ^ n19;
        n22 = n22 << 1 | n22 >>> 31;
        n6 = n6 << 30 | n6 >>> 2;
        n3 = n22 + ((n6 | n7) & n5 | n6 & n7) + (n4 << 5 | n4 >>> 27) + -1894007588 + n3;
        n2 = n2 ^ n9 ^ n15 ^ n20;
        n2 = n2 << 1 | n2 >>> 31;
        n7 = n7 << 30 | n7 >>> 2;
        n5 = n2 + ((n7 | n4) & n6 | n4 & n7) + (n3 << 5 | n3 >>> 27) + -1894007588 + n5;
        n8 = n8 ^ n10 ^ n16 ^ n21;
        n8 = n8 << 1 | n8 >>> 31;
        n4 = n4 << 30 | n4 >>> 2;
        n6 = n8 + ((n4 | n3) & n7 | n3 & n4) + (n5 << 5 | n5 >>> 27) + -1894007588 + n6;
        n9 = n9 ^ n11 ^ n17 ^ n22;
        n9 = n9 << 1 | n9 >>> 31;
        n3 = n3 << 30 | n3 >>> 2;
        n7 = n9 + ((n3 | n5) & n4 | n5 & n3) + (n6 << 5 | n6 >>> 27) + -1894007588 + n7;
        n10 = n10 ^ n12 ^ n18 ^ n2;
        n10 = n10 << 1 | n10 >>> 31;
        n5 = n5 << 30 | n5 >>> 2;
        n4 = n10 + ((n5 | n6) & n3 | n6 & n5) + (n7 << 5 | n7 >>> 27) + -1894007588 + n4;
        n11 = n11 ^ n13 ^ n19 ^ n8;
        n11 = n11 << 1 | n11 >>> 31;
        n6 = n6 << 30 | n6 >>> 2;
        n3 = n11 + ((n6 | n7) & n5 | n7 & n6) + (n4 << 5 | n4 >>> 27) + -1894007588 + n3;
        n12 = n12 ^ n14 ^ n20 ^ n9;
        n12 = n12 << 1 | n12 >>> 31;
        n7 = n7 << 30 | n7 >>> 2;
        n5 = n12 + ((n7 | n4) & n6 | n4 & n7) + (n3 << 5 | n3 >>> 27) + -1894007588 + n5;
        n13 = n13 ^ n15 ^ n21 ^ n10;
        n13 = n13 << 1 | n13 >>> 31;
        n4 = n4 << 30 | n4 >>> 2;
        n6 = n13 + ((n4 | n3) & n7 | n3 & n4) + (n5 << 5 | n5 >>> 27) + -1894007588 + n6;
        n14 = n14 ^ n16 ^ n22 ^ n11;
        n14 = n14 << 1 | n14 >>> 31;
        n3 = n3 << 30 | n3 >>> 2;
        n7 = n14 + ((n3 | n5) & n4 | n5 & n3) + (n6 << 5 | n6 >>> 27) + -1894007588 + n7;
        n15 = n15 ^ n17 ^ n2 ^ n12;
        n15 = n15 << 1 | n15 >>> 31;
        n5 = n5 << 30 | n5 >>> 2;
        n4 = n15 + ((n5 | n6) & n3 | n6 & n5) + (n7 << 5 | n7 >>> 27) + -1894007588 + n4;
        n16 = n16 ^ n18 ^ n8 ^ n13;
        n16 = n16 << 1 | n16 >>> 31;
        n6 = n6 << 30 | n6 >>> 2;
        n3 = n16 + ((n6 | n7) & n5 | n7 & n6) + (n4 << 5 | n4 >>> 27) + -1894007588 + n3;
        n17 = n17 ^ n19 ^ n9 ^ n14;
        n17 = n17 << 1 | n17 >>> 31;
        n7 = n7 << 30 | n7 >>> 2;
        n5 = n17 + ((n7 | n4) & n6 | n4 & n7) + (n3 << 5 | n3 >>> 27) + -1894007588 + n5;
        n18 = n18 ^ n20 ^ n10 ^ n15;
        n18 = n18 << 1 | n18 >>> 31;
        n4 = n4 << 30 | n4 >>> 2;
        n6 = n18 + ((n4 | n3) & n7 | n3 & n4) + (n5 << 5 | n5 >>> 27) + -1894007588 + n6;
        n19 = n19 ^ n21 ^ n11 ^ n16;
        n19 = n19 << 1 | n19 >>> 31;
        n3 = n3 << 30 | n3 >>> 2;
        n7 = n19 + (n3 ^ n5 ^ n4) + (n6 << 5 | n6 >>> 27) + -899497514 + n7;
        n20 = n20 ^ n22 ^ n12 ^ n17;
        n20 = n20 << 1 | n20 >>> 31;
        n5 = n5 << 30 | n5 >>> 2;
        n4 = n20 + (n5 ^ n6 ^ n3) + (n7 << 5 | n7 >>> 27) + -899497514 + n4;
        n21 = n21 ^ n2 ^ n13 ^ n18;
        n21 = n21 << 1 | n21 >>> 31;
        n6 = n6 << 30 | n6 >>> 2;
        n3 = n21 + (n6 ^ n7 ^ n5) + (n4 << 5 | n4 >>> 27) + -899497514 + n3;
        n22 = n22 ^ n8 ^ n14 ^ n19;
        n22 = n22 << 1 | n22 >>> 31;
        n7 = n7 << 30 | n7 >>> 2;
        n5 = n22 + (n7 ^ n4 ^ n6) + (n3 << 5 | n3 >>> 27) + -899497514 + n5;
        n2 = n2 ^ n9 ^ n15 ^ n20;
        n2 = n2 << 1 | n2 >>> 31;
        n4 = n4 << 30 | n4 >>> 2;
        n6 = n2 + (n4 ^ n3 ^ n7) + (n5 << 5 | n5 >>> 27) + -899497514 + n6;
        n8 = n8 ^ n10 ^ n16 ^ n21;
        n8 = n8 << 1 | n8 >>> 31;
        n3 = n3 << 30 | n3 >>> 2;
        n7 = n8 + (n3 ^ n5 ^ n4) + (n6 << 5 | n6 >>> 27) + -899497514 + n7;
        n9 = n9 ^ n11 ^ n17 ^ n22;
        n9 = n9 << 1 | n9 >>> 31;
        n5 = n5 << 30 | n5 >>> 2;
        n4 = n9 + (n5 ^ n6 ^ n3) + (n7 << 5 | n7 >>> 27) + -899497514 + n4;
        n10 = n10 ^ n12 ^ n18 ^ n2;
        n10 = n10 << 1 | n10 >>> 31;
        n6 = n6 << 30 | n6 >>> 2;
        n3 = n10 + (n6 ^ n7 ^ n5) + (n4 << 5 | n4 >>> 27) + -899497514 + n3;
        n11 = n11 ^ n13 ^ n19 ^ n8;
        n11 = n11 << 1 | n11 >>> 31;
        n7 = n7 << 30 | n7 >>> 2;
        n5 = n11 + (n7 ^ n4 ^ n6) + (n3 << 5 | n3 >>> 27) + -899497514 + n5;
        n12 = n12 ^ n14 ^ n20 ^ n9;
        n12 = n12 << 1 | n12 >>> 31;
        n4 = n4 << 30 | n4 >>> 2;
        n6 = n12 + (n4 ^ n3 ^ n7) + (n5 << 5 | n5 >>> 27) + -899497514 + n6;
        n13 = n13 ^ n15 ^ n21 ^ n10;
        n13 = n13 << 1 | n13 >>> 31;
        n3 = n3 << 30 | n3 >>> 2;
        n7 = n13 + (n3 ^ n5 ^ n4) + (n6 << 5 | n6 >>> 27) + -899497514 + n7;
        n14 = n14 ^ n16 ^ n22 ^ n11;
        n14 = n14 << 1 | n14 >>> 31;
        n5 = n5 << 30 | n5 >>> 2;
        n4 = n14 + (n5 ^ n6 ^ n3) + (n7 << 5 | n7 >>> 27) + -899497514 + n4;
        n15 = n15 ^ n17 ^ n2 ^ n12;
        n15 = n15 << 1 | n15 >>> 31;
        n6 = n6 << 30 | n6 >>> 2;
        n3 = n15 + (n6 ^ n7 ^ n5) + (n4 << 5 | n4 >>> 27) + -899497514 + n3;
        n16 = n16 ^ n18 ^ n8 ^ n13;
        n16 = n16 << 1 | n16 >>> 31;
        n7 = n7 << 30 | n7 >>> 2;
        n5 = n16 + (n7 ^ n4 ^ n6) + (n3 << 5 | n3 >>> 27) + -899497514 + n5;
        n17 = n17 ^ n19 ^ n9 ^ n14;
        n17 = n17 << 1 | n17 >>> 31;
        n4 = n4 << 30 | n4 >>> 2;
        n6 = n17 + (n4 ^ n3 ^ n7) + (n5 << 5 | n5 >>> 27) + -899497514 + n6;
        n18 = n18 ^ n20 ^ n10 ^ n15;
        n18 = n18 << 1 | n18 >>> 31;
        n3 = n3 << 30 | n3 >>> 2;
        n7 = n18 + (n3 ^ n5 ^ n4) + (n6 << 5 | n6 >>> 27) + -899497514 + n7;
        n19 = n19 ^ n21 ^ n11 ^ n16;
        n19 = n19 << 1 | n19 >>> 31;
        n5 = n5 << 30 | n5 >>> 2;
        n4 = n19 + (n5 ^ n6 ^ n3) + (n7 << 5 | n7 >>> 27) + -899497514 + n4;
        n20 = n20 ^ n22 ^ n12 ^ n17;
        n20 = n20 << 1 | n20 >>> 31;
        n6 = n6 << 30 | n6 >>> 2;
        n3 = n20 + (n6 ^ n7 ^ n5) + (n4 << 5 | n4 >>> 27) + -899497514 + n3;
        n21 = n21 ^ n2 ^ n13 ^ n18;
        n21 = n21 << 1 | n21 >>> 31;
        n7 = n7 << 30 | n7 >>> 2;
        n5 = n21 + (n7 ^ n4 ^ n6) + (n3 << 5 | n3 >>> 27) + -899497514 + n5;
        this.hB = n5 + this.hB;
        n22 = n22 ^ n8 ^ n14 ^ n19;
        n22 = n22 << 1 | n22 >>> 31;
        n4 = n4 << 30 | n4 >>> 2;
        this.hA = n22 + (n4 ^ n3 ^ n7) + (n5 << 5 | n5 >>> 27) + -899497514 + n6 + this.hA;
        this.hE = n7 + this.hE;
        this.hD = n4 + this.hD;
        this.hC = (n3 << 30 | n3 >>> 2) + this.hC;
    }
}

