/*
 * Decompiled with CFR 0.152.
 */
package com.bitzi.util;

public class Base32 {
    private static final char[] canonicalChars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '2', '3', '4', '5', '6', '7'};
    private static final int charDigitsBase = 50;
    private static final int[] charDigits = new int[]{26, 27, 28, 29, 30, 31, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25};
    private static final String errorNonCanonicalLength = "non canonical Base32-encoded string length";
    private static final String errorInvalidChar = "invalid character in Base32-encoded string";
    private static final String errorNonCanonicalEnd = "non canonical bits at end of Base32-encoded string";

    public static String encode(byte[] byArray) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = ((n << 3) + 4) / 5;
        char[] cArray = new char[n4];
        for (n = byArray.length; n != 0; n -= 5) {
            int n5 = byArray[n2] & 0xFF;
            cArray[n3] = canonicalChars[n5 >>> 3];
            int n6 = (n5 & 7) << 2;
            if (n == 1) {
                cArray[n3 + 1] = canonicalChars[n6];
                break;
            }
            n5 = byArray[n2 + 1] & 0xFF;
            cArray[n3 + 1] = canonicalChars[n5 >>> 6 | n6];
            cArray[n3 + 2] = canonicalChars[n5 >>> 1 & 0x1F];
            n6 = (n5 & 1) << 4;
            if (n == 2) {
                cArray[n3 + 3] = canonicalChars[n6];
                break;
            }
            n5 = byArray[n2 + 2] & 0xFF;
            cArray[n3 + 3] = canonicalChars[n5 >>> 4 | n6];
            n6 = (n5 & 0xF) << 1;
            if (n == 3) {
                cArray[n3 + 4] = canonicalChars[n6];
                break;
            }
            n5 = byArray[n2 + 3] & 0xFF;
            cArray[n3 + 4] = canonicalChars[n5 >>> 7 | n6];
            cArray[n3 + 5] = canonicalChars[n5 >>> 2 & 0x1F];
            n6 = (n5 & 3) << 3;
            if (n == 4) {
                cArray[n3 + 6] = canonicalChars[n6];
                break;
            }
            n5 = byArray[n2 + 4] & 0xFF;
            cArray[n3 + 6] = canonicalChars[n5 >>> 5 | n6];
            cArray[n3 + 7] = canonicalChars[n5 & 0x1F];
            n2 += 5;
            n3 += 8;
        }
        return new String(cArray);
    }

    public static byte[] decode(String string) throws IllegalArgumentException {
        int n;
        char[] cArray = string.toCharArray();
        switch (n & 7) {
            case 1: 
            case 3: 
            case 6: {
                throw new IllegalArgumentException(errorNonCanonicalLength);
            }
        }
        int n2 = charDigits.length;
        int n3 = n * 5 >>> 3;
        byte[] byArray = new byte[n3];
        int n4 = 0;
        int n5 = 0;
        for (n = cArray.length; n > 0; n -= 8) {
            int n6 = cArray[n5] - 50;
            if (n6 < 0 || n6 >= n2 || (n6 = charDigits[n6]) == -1) {
                throw new IllegalArgumentException(errorInvalidChar);
            }
            int n7 = n6 << 3;
            n6 = cArray[n5 + 1] - 50;
            if (n6 < 0 || n6 >= n2 || (n6 = charDigits[n6]) == -1) {
                throw new IllegalArgumentException(errorInvalidChar);
            }
            byArray[n4] = (byte)(n6 >> 2 | n7);
            n7 = (n6 & 3) << 6;
            if (n == 2) {
                if (n7 == 0) break;
                throw new IllegalArgumentException(errorNonCanonicalEnd);
            }
            n6 = cArray[n5 + 2] - 50;
            if (n6 < 0 || n6 >= n2 || (n6 = charDigits[n6]) == -1) {
                throw new IllegalArgumentException(errorInvalidChar);
            }
            n7 |= (byte)(n6 << 1);
            n6 = cArray[n5 + 3] - 50;
            if (n6 < 0 || n6 >= n2 || (n6 = charDigits[n6]) == -1) {
                throw new IllegalArgumentException(errorInvalidChar);
            }
            byArray[n4 + 1] = (byte)(n6 >> 4 | n7);
            n7 = (byte)((n6 & 0xF) << 4);
            if (n == 4) {
                if (n7 == 0) break;
                throw new IllegalArgumentException(errorNonCanonicalEnd);
            }
            n6 = cArray[n5 + 4] - 50;
            if (n6 < 0 || n6 >= n2 || (n6 = charDigits[n6]) == -1) {
                throw new IllegalArgumentException(errorInvalidChar);
            }
            byArray[n4 + 2] = (byte)(n6 >> 1 | n7);
            n7 = (byte)((n6 & 1) << 7);
            if (n == 5) {
                if (n7 == 0) break;
                throw new IllegalArgumentException(errorNonCanonicalEnd);
            }
            n6 = cArray[n5 + 5] - 50;
            if (n6 < 0 || n6 >= n2 || (n6 = charDigits[n6]) == -1) {
                throw new IllegalArgumentException(errorInvalidChar);
            }
            n7 |= (byte)(n6 << 2);
            n6 = cArray[n5 + 6] - 50;
            if (n6 < 0 || n6 >= n2 || (n6 = charDigits[n6]) == -1) {
                throw new IllegalArgumentException(errorInvalidChar);
            }
            byArray[n4 + 3] = (byte)(n6 >> 3 | n7);
            n7 = (byte)((n6 & 7) << 5);
            if (n == 7) {
                if (n7 == 0) break;
                throw new IllegalArgumentException(errorNonCanonicalEnd);
            }
            n6 = cArray[n5 + 7] - 50;
            if (n6 < 0 || n6 >= n2 || (n6 = charDigits[n6]) == -1) {
                throw new IllegalArgumentException(errorInvalidChar);
            }
            byArray[n4 + 4] = (byte)(n6 | n7);
            n5 += 8;
            n4 += 5;
        }
        return byArray;
    }
}

